package eu.codlab.http

import io.ktor.client.HttpClient
import io.ktor.client.engine.apache5.Apache5
import io.ktor.client.plugins.HttpTimeout
import io.ktor.client.plugins.auth.Auth
import io.ktor.client.plugins.contentnegotiation.ContentNegotiation
import io.ktor.client.plugins.logging.LogLevel
import io.ktor.client.plugins.logging.Logger
import io.ktor.client.plugins.logging.Logging
import io.ktor.client.plugins.logging.SIMPLE
import io.ktor.client.request.HttpRequestBuilder
import io.ktor.serialization.kotlinx.json.json
import kotlinx.serialization.json.Json

@Suppress("MagicNumber")
actual fun createClient(
    configuration: Configuration,
    onAuth: Auth.() -> Unit,
    onRequest: ((request: HttpRequestBuilder) -> Unit)?
): HttpClient {
    return HttpClient(Apache5) {
        install(Auth) {
            onAuth()
        }

        println("using logs ?")
        if (configuration.enableLogs) {
            println("true")
            install(Logging) {
                logger = Logger.SIMPLE
                level = LogLevel.ALL
            }
        } else {
            println("false")
        }

        install(HttpTimeout) {
            requestTimeoutMillis = 12000
        }

        if (null != onRequest) {
            install(InjectHeaderPlugin) {
                this.onRequest = onRequest
            }
        }

        install(ContentNegotiation) {
            json(
                Json {
                    ignoreUnknownKeys = true
                    prettyPrint = true
                }
            )
        }
    }
}
