package eu.codlab.google.maps.models

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

class GoogleMapsError(
    val googleError: GoogleMapsErrorObject
) : Exception()

@Serializable
data class SessionErrorResult(
    val error: GoogleMapsErrorObject
)

@Serializable
data class GoogleMapsErrorObject(
    val code: Int,
    val message: String,
    val errors: List<GoogleMapsErrorSubObject>,
    val status: String? = null,
    val details: List<GoogleMapsErrorDetail> = emptyList()
)

@Serializable
data class GoogleMapsErrorSubObject(
    val message: String? = null,
    val domain: String? = null,
    val reason: String
)

@Serializable
data class GoogleMapsErrorDetail(
    @SerialName("@type")
    val type: String,
    val reason: String? = null,
    val domain: String? = null,
    val locale: String? = null,
    val message: String? = null,
    val metadata: GoogleMapsErrorMetadata? = null,
    val fieldViolations: List<GoogleMapsErrorField>
)

@Serializable
data class GoogleMapsErrorField(
    val field: String,
    val description: String
)

@Serializable
data class GoogleMapsErrorMetadata(
    val service: String,
)
