/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.catchexception.throwable.apis;

import com.googlecode.catchexception.throwable.CatchThrowable;
import com.googlecode.catchexception.throwable.apis.CatchThrowableHamcrestMatchers;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.internal.matchers.Find;

public class CatchThrowableHamcrestMatchersTest {
    @Before
    public void setup() {
        ArrayList<String> fellowshipOfTheRing = new ArrayList<String>();
        fellowshipOfTheRing.add("frodo");
        fellowshipOfTheRing.add("sam");
        fellowshipOfTheRing.add("merry");
        fellowshipOfTheRing.add("pippin");
        fellowshipOfTheRing.add("gandalf");
        fellowshipOfTheRing.add("legolas");
        fellowshipOfTheRing.add("gimli");
        fellowshipOfTheRing.add("aragorn");
        fellowshipOfTheRing.add("boromir");
        ((List)CatchThrowable.catchThrowable(fellowshipOfTheRing)).get(9);
    }

    private void assertMessage(String foundMessage, String expectedExpectedPart, String expectedGotPart) {
        String[] foundParts = foundMessage.split("(?=but:)");
        Assert.assertEquals((String)("split of foundMessage did not work: " + foundMessage), (long)2L, (long)foundParts.length);
        String foundExpectedPart = foundParts[0].trim();
        String foundGotPart = foundParts[1].trim();
        Assert.assertEquals((Object)expectedExpectedPart, (Object)foundExpectedPart);
        Assert.assertEquals((Object)expectedGotPart, (Object)foundGotPart);
    }

    @Test
    public void testMatcher_instanceOf() {
        Assert.assertThat((Object)CatchThrowable.caughtThrowable(), (Matcher)CoreMatchers.instanceOf(IndexOutOfBoundsException.class));
        Assert.assertThat((Object)CatchThrowable.caughtThrowable(), (Matcher)CoreMatchers.isA(Throwable.class));
        try {
            Assert.assertThat((Object)CatchThrowable.caughtThrowable(), (Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class));
            throw new RuntimeException("AssertionError expected");
        }
        catch (AssertionError e) {
            this.assertMessage(((Throwable)((Object)e)).getMessage(), "Expected: an instance of java.lang.IllegalArgumentException", "but: <java.lang.IndexOutOfBoundsException: Index: 9, Size: 9> is a java.lang.IndexOutOfBoundsException");
            return;
        }
    }

    private static Matcher<String> containsPattern(String regex) {
        return new Find(regex);
    }

    @Test
    public void learningtestMatcher_hasMessage_findRegex() {
        Assert.assertThat((Object)CatchThrowable.caughtThrowable(), (Matcher)CatchThrowableHamcrestMatchers.hasMessageThat(CatchThrowableHamcrestMatchersTest.containsPattern("Index: \\d+")));
        try {
            Assert.assertThat((Object)CatchThrowable.caughtThrowable(), (Matcher)CatchThrowableHamcrestMatchers.hasMessageThat(CatchThrowableHamcrestMatchersTest.containsPattern("Index : \\d+")));
            throw new RuntimeException("AssertionError expected");
        }
        catch (AssertionError assertionError) {
            return;
        }
    }

    @Test
    public void testMatcher_hasMessage_equalByString() {
        Assert.assertThat((Object)CatchThrowable.caughtThrowable(), (Matcher)CatchThrowableHamcrestMatchers.hasMessage((String)"Index: 9, Size: 9"));
        try {
            Assert.assertThat((Object)CatchThrowable.caughtThrowable(), (Matcher)CatchThrowableHamcrestMatchers.hasMessage((String)"something went wrong"));
            throw new RuntimeException("AssertionError expected");
        }
        catch (AssertionError e) {
            this.assertMessage(((Throwable)((Object)e)).getMessage(), "Expected: has a message that is \"something went wrong\"", "but: was <java.lang.IndexOutOfBoundsException: Index: 9, Size: 9>");
            return;
        }
    }

    @Test
    public void testMatcher_hasMessage_equalByStringMatcher() {
        Assert.assertThat((Object)CatchThrowable.caughtThrowable(), (Matcher)CatchThrowableHamcrestMatchers.hasMessageThat((Matcher)CoreMatchers.is((Object)"Index: 9, Size: 9")));
        try {
            Assert.assertThat((Object)CatchThrowable.caughtThrowable(), (Matcher)CatchThrowableHamcrestMatchers.hasMessageThat((Matcher)CoreMatchers.is((Object)"something went wrong")));
            throw new RuntimeException("AssertionError expected");
        }
        catch (AssertionError e) {
            this.assertMessage(((Throwable)((Object)e)).getMessage(), "Expected: has a message that is \"something went wrong\"", "but: was <java.lang.IndexOutOfBoundsException: Index: 9, Size: 9>");
            return;
        }
    }

    @Test
    public void testMatcher_hasMessage_containsByStringMatcher() {
        Assert.assertThat((Object)CatchThrowable.caughtThrowable(), (Matcher)CatchThrowableHamcrestMatchers.hasMessageThat((Matcher)CoreMatchers.is((Matcher)CoreMatchers.containsString((String)"Index: 9"))));
        try {
            Assert.assertThat((Object)CatchThrowable.caughtThrowable(), (Matcher)CatchThrowableHamcrestMatchers.hasMessageThat((Matcher)CoreMatchers.is((Matcher)CoreMatchers.containsString((String)"Index: 8"))));
            throw new RuntimeException("AssertionError expected");
        }
        catch (AssertionError e) {
            this.assertMessage(((Throwable)((Object)e)).getMessage(), "Expected: has a message that is a string containing \"Index: 8\"", "but: was <java.lang.IndexOutOfBoundsException: Index: 9, Size: 9>");
            return;
        }
    }

    @Test
    public void testMatcher_hasNoCause() {
        Assert.assertThat((Object)CatchThrowable.caughtThrowable(), (Matcher)CatchThrowableHamcrestMatchers.hasNoCause());
        try {
            Assert.assertThat((Object)new RuntimeException(CatchThrowable.caughtThrowable()), (Matcher)CatchThrowableHamcrestMatchers.hasNoCause());
            throw new RuntimeException("AssertionError expected");
        }
        catch (AssertionError e) {
            this.assertMessage(((Throwable)((Object)e)).getMessage(), "Expected: has no cause", "but: was <java.lang.RuntimeException: java.lang.IndexOutOfBoundsException: Index: 9, Size: 9>");
            return;
        }
    }

    @Test
    public void testMatcher_allOf() {
        Assert.assertThat((Object)CatchThrowable.caughtThrowable(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.instanceOf(IndexOutOfBoundsException.class), (Matcher)CatchThrowableHamcrestMatchers.hasMessage((String)"Index: 9, Size: 9"), (Matcher)CatchThrowableHamcrestMatchers.hasNoCause()));
        try {
            Assert.assertThat((Object)CatchThrowable.caughtThrowable(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.instanceOf(IndexOutOfBoundsException.class), (Matcher)CatchThrowableHamcrestMatchers.hasMessage((String)"something went wrong"), (Matcher)CatchThrowableHamcrestMatchers.hasNoCause()));
            throw new RuntimeException("AssertionError expected");
        }
        catch (AssertionError e) {
            this.assertMessage(((Throwable)((Object)e)).getMessage(), "Expected: (an instance of java.lang.IndexOutOfBoundsException and has a message that is \"something went wrong\" and has no cause)", "but: has a message that is \"something went wrong\" was <java.lang.IndexOutOfBoundsException: Index: 9, Size: 9>");
            return;
        }
    }
}

