/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.catchexception.throwable;

import com.googlecode.catchexception.throwable.CatchThrowable;
import com.googlecode.catchexception.throwable.FinalMethodSomethingImpl;
import com.googlecode.catchexception.throwable.FinalSomethingImpl;
import com.googlecode.catchexception.throwable.MyThrowable;
import com.googlecode.catchexception.throwable.ProtectedSomethingImpl;
import com.googlecode.catchexception.throwable.PublicSomethingImpl;
import com.googlecode.catchexception.throwable.Something;
import com.googlecode.catchexception.throwable.ThrowableNotThrownAssertionError;
import com.googlecode.catchexception.throwable.internal.InterfaceOnlyProxy;
import com.googlecode.catchexception.throwable.internal.ThrowableHolder;
import java.net.HttpRetryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UnknownFormatConversionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CatchThrowableTest {
    private final List<String> list = new ArrayList<String>();
    private final String expectedMessage = "Index: 0, Size: 0";

    @Before
    public void setUp() {
        this.onSetup();
    }

    @After
    public void tearDown() {
        this.onTeardown();
    }

    protected void onSetup() {
        ThrowableHolder.set((Throwable)new HttpRetryException("detail", 0));
    }

    protected void onTeardown() {
    }

    @Test
    public void testProxyFactory_CanProxyNonVisibleClass() throws Exception {
        ((List)CatchThrowable.catchThrowable(Collections.unmodifiableList(this.list))).size();
        Assert.assertNull((Object)CatchThrowable.caughtThrowable());
        ((List)CatchThrowable.catchThrowable(Collections.unmodifiableList(this.list))).get(0);
        Assert.assertTrue((boolean)(CatchThrowable.caughtThrowable() instanceof IndexOutOfBoundsException));
        ((NonVisible)CatchThrowable.catchThrowable((Object)new NonVisible("sdfdfd"))).doesNotBelongToTheInterface();
        Assert.assertNull((Object)CatchThrowable.caughtThrowable());
    }

    @Test
    public void testProxyFactory_AnynomousType() throws Exception {
        PublicSomethingImpl obj = new PublicSomethingImpl(){

            @Override
            public void doThrow() {
                throw new UnknownFormatConversionException("sdfd");
            }
        };
        ((Something)CatchThrowable.catchThrowable((Object)obj)).doThrow();
        Assert.assertTrue((boolean)(CatchThrowable.caughtThrowable() instanceof UnknownFormatConversionException));
    }

    @Test
    public void testProxyFactory_AnynomousType_NotMappedAsInterface() throws Exception {
        PublicSomethingImpl obj = new PublicSomethingImpl(){

            @Override
            public void doThrow() {
                throw new UnknownFormatConversionException("sdfd");
            }
        };
        ((PublicSomethingImpl)CatchThrowable.catchThrowable((Object)obj)).doThrow();
        Assert.assertTrue((boolean)(CatchThrowable.caughtThrowable() instanceof UnknownFormatConversionException));
    }

    @Test
    public void testProxyFactory_ProtectedConstructor() {
        ((Something)CatchThrowable.catchThrowable((Object)new ProtectedSomethingImpl())).doThrow();
        Assert.assertTrue((boolean)(CatchThrowable.caughtThrowable() instanceof UnsupportedOperationException));
    }

    @Test
    public void testProxyFactory_KnownLimitation_CannotProxyFinalClass() throws Exception {
        Object obj;
        try {
            obj = new FinalSomethingImpl();
            ((FinalSomethingImpl)CatchThrowable.catchThrowable((Object)obj)).doesNotBelongToAnyInterface();
            Assert.fail((String)"Exception expected as the class is final");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            obj = new FinalSomethingImpl();
            ((FinalSomethingImpl)CatchThrowable.catchThrowable((Object)obj)).doThrow();
            Assert.fail((String)"Exception expected as the class is final");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            obj = new StringBuilder();
            ((StringBuilder)CatchThrowable.catchThrowable((Object)obj)).charAt(-2);
            Assert.fail((String)"Exception expected as the class is final");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void testProxyFactory_KnownLimitation_CannotProxyFinalClass_theWorkaroundUsesInterface() throws Exception {
        FinalSomethingImpl obj = new FinalSomethingImpl();
        ((Something)CatchThrowable.catchThrowable((Object)obj)).doThrow();
        Assert.assertTrue((boolean)(CatchThrowable.caughtThrowable() instanceof UnsupportedOperationException));
        CatchThrowable.resetCaughtThrowable();
        ((Something)CatchThrowable.catchThrowable((Object)new FinalSomethingImpl())).doThrow();
        Assert.assertTrue((boolean)(CatchThrowable.caughtThrowable() instanceof UnsupportedOperationException));
        CatchThrowable.resetCaughtThrowable();
        StringBuilder sb = new StringBuilder();
        ((CharSequence)CatchThrowable.catchThrowable((Object)sb)).charAt(-2);
        Assert.assertTrue((boolean)(CatchThrowable.caughtThrowable() instanceof StringIndexOutOfBoundsException));
        CatchThrowable.resetCaughtThrowable();
        sb = new StringBuilder();
        ((CharSequence)CatchThrowable.catchThrowable((Object)sb)).charAt(-2);
        Assert.assertTrue((boolean)(CatchThrowable.caughtThrowable() instanceof StringIndexOutOfBoundsException));
    }

    @Test
    public void testProxyFactory_KnownLimitation_CannotInterceptFinalMethod() throws Exception {
        try {
            FinalMethodSomethingImpl obj = new FinalMethodSomethingImpl();
            ((FinalMethodSomethingImpl)CatchThrowable.catchThrowable((Object)obj)).doThrow();
            Assert.fail((String)"UnsupportedOperationException is not expected to be caught");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testProxyFactory_KnownLimitation_CannotInterceptFinalMethod_theWorkaroundUsesInterface() throws Exception {
        FinalMethodSomethingImpl obj = new FinalMethodSomethingImpl();
        ((Something)CatchThrowable.catchThrowable((Object)CatchThrowable.interfaces((Object)obj))).doThrow();
        Assert.assertTrue((boolean)(CatchThrowable.caughtThrowable() instanceof UnsupportedOperationException));
        obj = new FinalMethodSomethingImpl();
        ((Something)CatchThrowable.catchThrowable((Object)((Something)CatchThrowable.interfaces((Object)obj)))).doThrow();
        Assert.assertTrue((boolean)(CatchThrowable.caughtThrowable() instanceof UnsupportedOperationException));
    }

    @Test
    public void testProxyFactory_ProxyForClassNotInterface() throws Exception {
        ArrayList arrayList = new ArrayList();
        ((List)CatchThrowable.catchThrowable(arrayList)).get(0);
        Assert.assertTrue((boolean)(CatchThrowable.caughtThrowable() instanceof IndexOutOfBoundsException));
    }

    @Test
    public void testCatchException_ObjExc_noExceptionThrown() throws Exception {
        ((List)CatchThrowable.catchThrowable(this.list, IndexOutOfBoundsException.class)).size();
        Assert.assertNull((Object)CatchThrowable.caughtThrowable());
    }

    @Test
    public void testCatchException_ObjExc_actualClassThrown() throws Exception {
        ((List)CatchThrowable.catchThrowable(this.list, IndexOutOfBoundsException.class)).get(0);
        Assert.assertEquals((Object)"Index: 0, Size: 0", (Object)CatchThrowable.caughtThrowable().getMessage());
    }

    @Test
    public void testCatchException_ObjExc_subClassOfExpectedThrown() throws Exception {
        ((List)CatchThrowable.catchThrowable(this.list, RuntimeException.class)).get(0);
        Assert.assertEquals((Object)"Index: 0, Size: 0", (Object)CatchThrowable.caughtThrowable().getMessage());
    }

    @Test
    public void testCatchException_ObjExc_superClassOfExpectedThrown() throws Exception {
        try {
            ((List)CatchThrowable.catchThrowable(this.list, ArrayIndexOutOfBoundsException.class)).get(0);
            Assert.fail((String)"IndexOutOfBoundsException is expected (shall not be caught)");
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertNull((Object)CatchThrowable.caughtThrowable());
        }
    }

    @Test
    public void testCatchException_ObjExc_otherClassThanExpectedThrown() throws Exception {
        try {
            ((List)CatchThrowable.catchThrowable(this.list, IllegalArgumentException.class)).get(0);
            Assert.fail((String)"IndexOutOfBoundsException is expected (shall not be caught)");
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertNull((Object)CatchThrowable.caughtThrowable());
        }
    }

    @Test
    public void testCatchException_ObjExc_missingArgument_Exception() throws Exception {
        try {
            CatchThrowable.catchThrowable(this.list, null);
            Assert.fail((String)"IllegalArgumentException is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"throwableClazz must not be null", (Object)e.getMessage());
        }
    }

    @Test
    public void testCatchException_ObjExc_missingArgument_Object() throws Exception {
        try {
            CatchThrowable.catchThrowable(null, IllegalArgumentException.class);
            Assert.fail((String)"IllegalArgumentException is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"obj must not be null", (Object)e.getMessage());
        }
    }

    @Test
    public void testverifyThrowable_ObjExc_noExceptionThrown() throws Exception {
        try {
            ((List)CatchThrowable.verifyThrowable(this.list, IndexOutOfBoundsException.class)).size();
            Assert.fail((String)"ThrowableNotThrownAssertionError is expected");
        }
        catch (ThrowableNotThrownAssertionError e) {
            Assert.assertNull((Object)CatchThrowable.caughtThrowable());
            Assert.assertEquals((Object)("Neither a throwable of type " + IndexOutOfBoundsException.class.getName() + " nor another throwable was thrown"), (Object)e.getMessage());
        }
    }

    @Test
    public void testverifyThrowable_ObjExc_actualClassThrown() throws Exception {
        ((List)CatchThrowable.verifyThrowable(this.list, IndexOutOfBoundsException.class)).get(0);
        Assert.assertEquals((Object)"Index: 0, Size: 0", (Object)CatchThrowable.caughtThrowable().getMessage());
    }

    @Test
    public void testverifyThrowable_ObjExc_subClassOfExpectedThrown() throws Exception {
        ((List)CatchThrowable.verifyThrowable(this.list, RuntimeException.class)).get(0);
        Assert.assertEquals((Object)"Index: 0, Size: 0", (Object)CatchThrowable.caughtThrowable().getMessage());
    }

    @Test
    public void testverifyThrowable_ObjExc_superClassOfExpectedThrown() throws Exception {
        try {
            ((List)CatchThrowable.verifyThrowable(this.list, ArrayIndexOutOfBoundsException.class)).get(0);
            Assert.fail((String)"ThrowableNotThrownAssertionError is expected");
        }
        catch (ThrowableNotThrownAssertionError e) {
            Assert.assertNull((Object)CatchThrowable.caughtThrowable());
            Assert.assertEquals((Object)("Throwable of type " + ArrayIndexOutOfBoundsException.class.getName() + " expected but was not thrown." + " Instead a throwable of type " + IndexOutOfBoundsException.class + " with message '" + "Index: 0, Size: 0" + "' was thrown."), (Object)e.getMessage());
        }
    }

    @Test
    public void testverifyThrowable_ObjExc_otherClassThanExpectedThrown() throws Exception {
        try {
            ((List)CatchThrowable.verifyThrowable(this.list, IllegalArgumentException.class)).get(0);
            Assert.fail((String)"ThrowableNotThrownAssertionError is expected");
        }
        catch (ThrowableNotThrownAssertionError e) {
            Assert.assertNull((Object)CatchThrowable.caughtThrowable());
            Assert.assertEquals((Object)("Throwable of type " + IllegalArgumentException.class.getName() + " expected but was not thrown." + " Instead a throwable of type " + IndexOutOfBoundsException.class + " with message '" + "Index: 0, Size: 0" + "' was thrown."), (Object)e.getMessage());
        }
    }

    @Test
    public void testverifyThrowable_ObjExc_missingArgument_Exception() throws Exception {
        try {
            CatchThrowable.verifyThrowable(this.list, null);
            Assert.fail((String)"IllegalArgumentException is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"throwableClazz must not be null", (Object)e.getMessage());
        }
    }

    @Test
    public void testverifyThrowable_ObjExc_missingArgument_Object() throws Exception {
        try {
            CatchThrowable.verifyThrowable(null, IllegalArgumentException.class);
            Assert.fail((String)"IllegalArgumentException is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"obj must not be null", (Object)e.getMessage());
        }
    }

    @Test
    public void testverifyThrowable_Obj_noExceptionThrown() throws Exception {
        ArrayList list = new ArrayList();
        try {
            ((List)CatchThrowable.verifyThrowable(list)).size();
            Assert.fail((String)"ThrowableNotThrownAssertionError is expected");
        }
        catch (ThrowableNotThrownAssertionError e) {
            Assert.assertNull((Object)CatchThrowable.caughtThrowable());
            Assert.assertEquals((Object)"Throwable expected but not thrown", (Object)e.getMessage());
        }
    }

    @Test
    public void testverifyThrowable_Obj_exceptionThrown() throws Exception {
        ArrayList list = new ArrayList();
        ((List)CatchThrowable.verifyThrowable(list)).get(0);
        Assert.assertEquals((Object)"Index: 0, Size: 0", (Object)CatchThrowable.caughtThrowable().getMessage());
    }

    @Test
    public void testverifyThrowable_Obj_missingArgument_Object() throws Exception {
        try {
            CatchThrowable.verifyThrowable(null);
            Assert.fail((String)"IllegalArgumentException is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"obj must not be null", (Object)e.getMessage());
        }
    }

    @Test
    public void testCatchException_Obj_noExceptionThrown() throws Exception {
        ArrayList list = new ArrayList();
        ((List)CatchThrowable.catchThrowable(list)).size();
        Assert.assertNull((Object)CatchThrowable.caughtThrowable());
    }

    @Test
    public void testCatchException_Obj_exceptionThrown() throws Exception {
        ArrayList list = new ArrayList();
        ((List)CatchThrowable.catchThrowable(list)).get(0);
        Assert.assertEquals((Object)"Index: 0, Size: 0", (Object)CatchThrowable.caughtThrowable().getMessage());
    }

    @Test
    public void testCatchException_Obj_missingArgument_Object() throws Exception {
        try {
            CatchThrowable.catchThrowable(null);
            Assert.fail((String)"IllegalArgumentException is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"obj must not be null", (Object)e.getMessage());
        }
    }

    @Test
    public void testCatchException_TestedMethodThrowsError_CgLibProxy() throws Exception {
        PublicSomethingImpl obj = new PublicSomethingImpl();
        PublicSomethingImpl proxy = (PublicSomethingImpl)CatchThrowable.catchThrowable((Object)obj);
        Assert.assertFalse((boolean)(proxy instanceof InterfaceOnlyProxy));
        proxy.doThrowAssertionError();
        Assert.assertTrue((boolean)(CatchThrowable.caughtThrowable() instanceof AssertionError));
        CatchThrowable.resetCaughtThrowable();
        try {
            proxy = (PublicSomethingImpl)CatchThrowable.catchThrowable((Object)obj, NoSuchMethodError.class);
            Assert.assertFalse((boolean)(proxy instanceof InterfaceOnlyProxy));
            proxy.doThrowAssertionError();
            Assert.fail((String)"AssertionError must not be caught");
        }
        catch (AssertionError e) {
            if (((Throwable)((Object)e)).getMessage().equals("AssertionError must not be caught")) {
                throw e;
            }
            Assert.assertEquals((Object)"123", (Object)((Throwable)((Object)e)).getMessage());
        }
        CatchThrowable.resetCaughtThrowable();
        proxy = (PublicSomethingImpl)CatchThrowable.catchThrowable((Object)obj, NoSuchMethodError.class);
        Assert.assertFalse((boolean)(proxy instanceof InterfaceOnlyProxy));
        proxy.doThrowNoSuchMethodError();
        Assert.assertTrue((boolean)(CatchThrowable.caughtThrowable() instanceof NoSuchMethodError));
    }

    @Test
    public void testCatchException_TestedMethodThrowsError_JdkProxy() throws Exception {
        FinalSomethingImpl obj = new FinalSomethingImpl();
        Something proxy = (Something)CatchThrowable.catchThrowable((Object)obj);
        Assert.assertTrue((boolean)(proxy instanceof InterfaceOnlyProxy));
        proxy.doThrowAssertionError();
        Assert.assertTrue((boolean)(CatchThrowable.caughtThrowable() instanceof AssertionError));
        CatchThrowable.resetCaughtThrowable();
        try {
            proxy = (Something)CatchThrowable.catchThrowable((Object)obj, NoSuchMethodError.class);
            Assert.assertTrue((boolean)(proxy instanceof InterfaceOnlyProxy));
            proxy.doThrowAssertionError();
            Assert.fail((String)"AssertionError must not be caught");
        }
        catch (AssertionError e) {
            if (((Throwable)((Object)e)).getMessage().equals("AssertionError must not be caught")) {
                throw e;
            }
            Assert.assertEquals((Object)"123", (Object)((Throwable)((Object)e)).getMessage());
        }
        proxy = (Something)CatchThrowable.catchThrowable((Object)obj, NoSuchMethodError.class);
        Assert.assertTrue((boolean)(proxy instanceof InterfaceOnlyProxy));
        proxy.doThrowNoSuchMethodError();
        Assert.assertTrue((boolean)(CatchThrowable.caughtThrowable() instanceof NoSuchMethodError));
    }

    @Test
    public void testInterfaces_MissingArgument() throws Exception {
        try {
            CatchThrowable.interfaces(null);
            Assert.fail((String)"IllegalArgumentException is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"obj must not be null", (Object)e.getMessage());
        }
    }

    @Test
    public void testInterfaces_doesNotSubclass() throws Exception {
        try {
            PublicSomethingImpl obj = (PublicSomethingImpl)CatchThrowable.interfaces((Object)new PublicSomethingImpl());
            Assert.fail((String)"ClassCastException is expected");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void testInterfaces_delegates() throws Exception {
        try {
            Something obj = (Something)CatchThrowable.interfaces((Object)new PublicSomethingImpl());
            obj.doThrow();
            Assert.fail((String)"UnsupportedOperationException is expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testProtected() throws Exception {
        PublicSomethingImpl obj = new PublicSomethingImpl();
        ((PublicSomethingImpl)CatchThrowable.catchThrowable((Object)obj)).dooo();
        Assert.assertTrue((boolean)(CatchThrowable.caughtThrowable() instanceof MyThrowable));
    }

    private static class NonVisible
    implements Something {
        private NonVisible(String fsdfsdfd) {
        }

        @Override
        public void doThrow() {
            throw new UnsupportedOperationException("siodsdnsgz");
        }

        public void doesNotBelongToTheInterface() {
        }

        @Override
        public void doThrowAssertionError() {
        }

        @Override
        public void doThrowNoSuchMethodError() {
        }
    }
}

