/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.tcp.handler.forwarder;

import eu.clarussecure.proxy.protocol.plugins.tcp.TCPConstants;
import eu.clarussecure.proxy.protocol.plugins.tcp.TCPSession;
import eu.clarussecure.proxy.protocol.plugins.tcp.handler.forwarder.FilterableMessage;
import eu.clarussecure.proxy.protocol.plugins.tcp.handler.forwarder.MessageForwarder;
import eu.clarussecure.proxy.spi.protocol.Configuration;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;

public class ServerMessageForwarder<I>
extends MessageForwarder<I> {
    public ServerMessageForwarder() {
        super(false);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        boolean allConnectionCompleted;
        if (LOGGER.isDebugEnabled()) {
            Configuration configuration = (Configuration)ctx.channel().attr(TCPConstants.CONFIGURATION_KEY).get();
            LOGGER.debug("{} connection to {} completed", (Object)this.direction, (Object)configuration.getServerEndpoint());
        }
        ctx.channel().config().setAutoRead(true);
        TCPSession session = (TCPSession)ctx.channel().attr(TCPConstants.SESSION_KEY).get();
        boolean bl = allConnectionCompleted = session.decrementAndGetExpectedConnections() == 0;
        if (allConnectionCompleted) {
            Channel clientSideChannel = session.getClientSideChannel();
            clientSideChannel.config().setAutoRead(true);
        }
        super.channelActive(ctx);
        if (allConnectionCompleted && LOGGER.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (Channel serverSidechannel : session.getServerSideChannels()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(serverSidechannel.remoteAddress());
            }
            LOGGER.info("Intercepting traffic between {} and {}", (Object)session.getClientSideChannel().remoteAddress(), (Object)sb.toString());
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, I msg) throws Exception {
        boolean forward;
        if (msg instanceof FilterableMessage && ((FilterableMessage)msg).filter()) {
            Integer preferredServerEndpoint = (Integer)ctx.channel().attr(TCPConstants.PREFERRED_SERVER_ENDPOINT_KEY).get();
            if (preferredServerEndpoint == null) {
                throw new NullPointerException(TCPConstants.PREFERRED_SERVER_ENDPOINT_KEY.name() + " is not set");
            }
            Integer serverEndpointNumber = (Integer)ctx.channel().attr(TCPConstants.SERVER_ENDPOINT_NUMBER_KEY).get();
            if (serverEndpointNumber == null) {
                throw new NullPointerException(TCPConstants.SERVER_ENDPOINT_NUMBER_KEY.name() + " is not set");
            }
            forward = preferredServerEndpoint == -1 || preferredServerEndpoint == serverEndpointNumber;
        } else {
            forward = true;
        }
        if (forward) {
            Channel sinkChannel = this.getSinkChannels(ctx).get(0);
            this.forwardMessage(msg, sinkChannel);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Message not forwarded");
        }
    }
}

