/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.tcp.handler.forwarder;

import eu.clarussecure.proxy.protocol.plugins.tcp.TCPConstants;
import eu.clarussecure.proxy.protocol.plugins.tcp.TCPSession;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageForwarder<I>
extends SimpleChannelInboundHandler<I> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MessageForwarder.class);
    protected boolean client;
    protected String direction;

    public MessageForwarder(boolean client) {
        this.client = client;
        this.direction = client ? "(C->S)" : "(C<-S)";
    }

    protected void forwardMessage(I msg, Channel sinkChannel) {
        if (sinkChannel != null && sinkChannel.isActive()) {
            LOGGER.trace("{} Forward message: {} ", (Object)this.direction, msg);
            ReferenceCountUtil.retain(msg);
            sinkChannel.writeAndFlush(msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        List<Channel> sinkChannels;
        if (this.closeSinkChannels(ctx) && (sinkChannels = this.getSinkChannels(ctx)) != null) {
            for (Channel sinkChannel : sinkChannels) {
                if (!sinkChannel.isActive()) continue;
                LOGGER.debug("{} Forward close", (Object)this.direction);
                sinkChannel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        super.channelInactive(ctx);
    }

    protected boolean closeSinkChannels(ChannelHandlerContext ctx) {
        return true;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        List<Channel> sinkChannels = this.getSinkChannels(ctx);
        if (sinkChannels != null) {
            for (Channel sinkChannel : sinkChannels) {
                if (!sinkChannel.isActive()) continue;
                LOGGER.error("{} Close on error", (Object)this.direction);
                sinkChannel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        super.exceptionCaught(ctx, cause);
    }

    protected List<Channel> getSinkChannels(ChannelHandlerContext ctx) {
        List<Channel> sinkChannels = null;
        TCPSession session = (TCPSession)ctx.channel().attr(TCPConstants.SESSION_KEY).get();
        if (session != null) {
            sinkChannels = this.client ? session.getServerSideChannels() : Collections.singletonList(session.getClientSideChannel());
        }
        return sinkChannels;
    }
}

