/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.tcp.handler.forwarder;

import eu.clarussecure.proxy.protocol.plugins.tcp.TCPClient;
import eu.clarussecure.proxy.protocol.plugins.tcp.TCPConstants;
import eu.clarussecure.proxy.protocol.plugins.tcp.TCPSession;
import eu.clarussecure.proxy.protocol.plugins.tcp.handler.forwarder.DirectedMessage;
import eu.clarussecure.proxy.protocol.plugins.tcp.handler.forwarder.MessageForwarder;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import java.util.List;

public abstract class ClientMessageForwarder<I, S extends TCPSession>
extends MessageForwarder<I> {
    private Class<S> sessionType;

    public ClientMessageForwarder(Class<S> sessionType) {
        super(true);
        this.sessionType = sessionType;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        LOGGER.debug("{} new client connection from {}", (Object)this.direction, (Object)ctx.channel().remoteAddress());
        TCPClient<S> client = new TCPClient<S>(ctx, this.sessionType);
        client.call();
        super.channelActive(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof DirectedMessage) {
            boolean release = true;
            try {
                Object msg2 = ((DirectedMessage)msg).getMsg();
                int to = ((DirectedMessage)msg).getTo();
                if (this.acceptInboundMessage(msg2)) {
                    Object imsg = msg2;
                    this.forwardMessage(ctx, imsg, to);
                }
                release = false;
                ctx.fireChannelRead(msg);
            }
            finally {
                if (release) {
                    ReferenceCountUtil.release((Object)msg);
                }
            }
        } else {
            super.channelRead(ctx, msg);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, I msg) throws Exception {
        Integer preferredServerEndpoint = (Integer)ctx.channel().attr(TCPConstants.PREFERRED_SERVER_ENDPOINT_KEY).get();
        if (preferredServerEndpoint == null) {
            throw new NullPointerException(TCPConstants.PREFERRED_SERVER_ENDPOINT_KEY.name() + " is not set");
        }
        this.forwardMessage(ctx, msg, preferredServerEndpoint);
    }

    private void forwardMessage(ChannelHandlerContext ctx, I msg, int to) {
        List<Channel> sinkChannels = this.getSinkChannels(ctx);
        if (to < -1 || to >= sinkChannels.size()) {
            throw new IndexOutOfBoundsException(String.format("index: {}, number of channel: {}", to, sinkChannels.size()));
        }
        if (to == -1) {
            for (int i = 0; i < sinkChannels.size(); ++i) {
                Channel sinkChannel = sinkChannels.get(i);
                if (msg instanceof ByteBufHolder) {
                    Object msg2 = msg;
                    if (i > 0) {
                        msg2 = ((ByteBufHolder)msg).duplicate();
                    }
                    this.forwardMessage(msg2, sinkChannel);
                    continue;
                }
                this.forwardMessage(msg, sinkChannel);
            }
        } else {
            Channel sinkChannel = sinkChannels.get(to);
            this.forwardMessage(msg, sinkChannel);
        }
    }
}

