/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.tcp;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class TCPSession {
    private Channel clientSideChannel;
    private List<Channel> serverSideChannels;
    private AtomicInteger expectedConnections = new AtomicInteger(0);

    public Channel getClientSideChannel() {
        return this.clientSideChannel;
    }

    public void setClientSideChannel(Channel clientSideChannel) {
        this.clientSideChannel = clientSideChannel;
    }

    public List<Channel> getServerSideChannels() {
        if (this.serverSideChannels == null) {
            this.serverSideChannels = new ArrayList<Channel>();
        }
        return this.serverSideChannels;
    }

    public Channel getServerSideChannel(int server) {
        if (server < 0 || server >= this.getServerSideChannels().size()) {
            throw new IndexOutOfBoundsException(String.format("server: {}, number of server: {}", server, this.getServerSideChannels().size()));
        }
        return this.serverSideChannels.get(server);
    }

    public void setServerSideChannels(List<Channel> serverSideChannels) {
        this.serverSideChannels = serverSideChannels;
    }

    public void addServerSideChannel(Channel serverSideChannel) {
        this.getServerSideChannels().add(serverSideChannel);
    }

    public void removeServerSideChannel(Channel serverSideChannel) {
        this.getServerSideChannels().remove(serverSideChannel);
    }

    public int getExpectedConnections() {
        return this.expectedConnections.get();
    }

    public void setExpectedConnections(int expectedConnections) {
        this.expectedConnections.set(expectedConnections);
    }

    public int decrementAndGetExpectedConnections() {
        return this.expectedConnections.decrementAndGet();
    }
}

