/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.tcp;

import eu.clarussecure.proxy.protocol.plugins.tcp.TCPConstants;
import eu.clarussecure.proxy.spi.protocol.Configuration;
import eu.clarussecure.proxy.spi.protocol.ProtocolServer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPServer<CI extends ChannelInitializer<Channel>, SI extends ChannelInitializer<Channel>>
implements ProtocolServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TCPServer.class);
    private final Configuration configuration;
    private final Map<String, Object> customData;
    private final Class<CI> clientSideChannelInitializerType;
    private final Class<SI> serverSideChannelInitializerType;
    private final int preferredServerEndpoint;
    private volatile boolean ready = false;

    public TCPServer(Configuration configuration, Class<CI> clientSideChannelInitializerType, Class<SI> serverSideChannelInitializerType, int preferredServerEndpoint) {
        this.configuration = configuration;
        this.customData = new HashMap<String, Object>();
        this.clientSideChannelInitializerType = clientSideChannelInitializerType;
        this.serverSideChannelInitializerType = serverSideChannelInitializerType;
        this.preferredServerEndpoint = preferredServerEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void call() throws Exception {
        NioEventLoopGroup acceptorGroup = new NioEventLoopGroup(this.configuration.getNbListenThreads());
        NioEventLoopGroup childGroup = new NioEventLoopGroup(this.configuration.getNbSessionThreads());
        try {
            ChannelInitializer<Channel> clientSidePipelineInitializer = this.buildClientSidePipelineInitializer();
            ChannelInitializer<Channel> serverSidePipelineInitializer = this.buildServerSidePipelineInitializer();
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)acceptorGroup, (EventLoopGroup)childGroup).channel(NioServerSocketChannel.class)).localAddress((SocketAddress)new InetSocketAddress(this.configuration.getListenPort()))).childAttr(TCPConstants.CONFIGURATION_KEY, (Object)this.configuration).childAttr(TCPConstants.CUSTOM_DATA_KEY, this.customData).childAttr(TCPConstants.PREFERRED_SERVER_ENDPOINT_KEY, (Object)this.preferredServerEndpoint).childAttr(TCPConstants.SERVER_INITIALIZER_KEY, serverSidePipelineInitializer).childHandler(clientSidePipelineInitializer).childOption(ChannelOption.AUTO_READ, (Object)false);
            ChannelFuture f = bootstrap.bind().sync();
            LOGGER.info("Server ready to serve requests at:" + f.channel().localAddress());
            TCPServer tCPServer = this;
            synchronized (tCPServer) {
                this.ready = true;
                this.notifyAll();
            }
            f.channel().closeFuture().sync();
        }
        finally {
            acceptorGroup.shutdownGracefully().sync();
            childGroup.shutdownGracefully().sync();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForServerIsReady() throws InterruptedException {
        while (!this.ready) {
            TCPServer tCPServer = this;
            synchronized (tCPServer) {
                if (!this.ready) {
                    this.wait();
                }
            }
        }
    }

    protected ChannelInitializer<Channel> buildClientSidePipelineInitializer() {
        try {
            return (ChannelInitializer)this.clientSideChannelInitializerType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.error("Cannot create instance of class {}: ", (Object)this.clientSideChannelInitializerType.getSimpleName(), (Object)e);
            throw new IllegalArgumentException(String.format("Cannot create instance of class %s: ", this.clientSideChannelInitializerType.getSimpleName(), e));
        }
    }

    protected ChannelInitializer<Channel> buildServerSidePipelineInitializer() {
        try {
            return (ChannelInitializer)this.serverSideChannelInitializerType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.error("Cannot create instance of class {}: ", (Object)this.serverSideChannelInitializerType.getSimpleName(), (Object)e);
            throw new IllegalArgumentException(String.format("Cannot create instance of class %s: ", this.serverSideChannelInitializerType.getSimpleName(), e));
        }
    }
}

