/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.tcp;

import eu.clarussecure.proxy.protocol.plugins.tcp.TCPConstants;
import eu.clarussecure.proxy.protocol.plugins.tcp.TCPSession;
import eu.clarussecure.proxy.spi.protocol.Configuration;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPClient<S extends TCPSession>
implements Callable<Void> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(TCPClient.class);
    private final ChannelHandlerContext ctx;
    private final Class<S> sessionType;

    public TCPClient(ChannelHandlerContext ctx, Class<S> sessionType) {
        this.ctx = ctx;
        this.sessionType = sessionType;
    }

    @Override
    public Void call() throws Exception {
        Channel clientSideChannel = this.ctx.channel();
        Configuration configuration = (Configuration)clientSideChannel.attr(TCPConstants.CONFIGURATION_KEY).get();
        Map customData = (Map)clientSideChannel.attr(TCPConstants.CUSTOM_DATA_KEY).get();
        ChannelInitializer serverSidePipelineInitializer = (ChannelInitializer)clientSideChannel.attr(TCPConstants.SERVER_INITIALIZER_KEY).get();
        Bootstrap bootstrap = new Bootstrap();
        TCPSession session = this.buildSession();
        session.setClientSideChannel(clientSideChannel);
        clientSideChannel.attr(TCPConstants.SESSION_KEY).set((Object)session);
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)clientSideChannel.eventLoop())).channel(NioSocketChannel.class)).attr(TCPConstants.CONFIGURATION_KEY, (Object)configuration)).attr(TCPConstants.CUSTOM_DATA_KEY, (Object)customData)).attr(TCPConstants.SESSION_KEY, (Object)session)).attr(TCPConstants.PREFERRED_SERVER_ENDPOINT_KEY, clientSideChannel.attr(TCPConstants.PREFERRED_SERVER_ENDPOINT_KEY).get())).handler((ChannelHandler)serverSidePipelineInitializer)).option(ChannelOption.AUTO_READ, (Object)false);
        session.setExpectedConnections(configuration.getServerEndpoints().size());
        for (int i = 0; i < configuration.getServerEndpoints().size(); ++i) {
            InetSocketAddress serverEndpoint = (InetSocketAddress)configuration.getServerEndpoints().get(i);
            LOGGER.trace("Initialize connection to {}", (Object)serverEndpoint);
            ChannelFuture connectFuture = bootstrap.connect((SocketAddress)serverEndpoint);
            Channel serverSideChannel = connectFuture.channel();
            session.addServerSideChannel(serverSideChannel);
            serverSideChannel.attr(TCPConstants.SERVER_ENDPOINT_NUMBER_KEY).set((Object)i);
        }
        return null;
    }

    protected TCPSession buildSession() {
        try {
            return (TCPSession)this.sessionType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.error("Cannot create instance of class {}: ", (Object)this.sessionType.getSimpleName(), (Object)e);
            throw new IllegalArgumentException(String.format("Cannot create instance of class %s: ", this.sessionType.getSimpleName(), e));
        }
    }
}

