/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.codec;

import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.PgsqlRawPart;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgsqlRawPartEncoder
extends MessageToByteEncoder<PgsqlRawPart> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PgsqlRawPartEncoder.class);
    private String to;

    public PgsqlRawPartEncoder(boolean frontend) {
        this.to = frontend ? "(F<-)" : "(->B)";
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, PgsqlRawPart msg, boolean preferDirect) throws Exception {
        return msg.getBytes().readRetainedSlice(msg.getBytes().readableBytes());
    }

    protected void encode(ChannelHandlerContext ctx, PgsqlRawPart msg, ByteBuf out) throws Exception {
        LOGGER.trace("{} Encoding raw message part: {}...", (Object)this.to, (Object)msg);
        LOGGER.trace("{} {} bytes encoded", (Object)this.to, (Object)out.readableBytes());
    }
}

