/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.codec;

import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.DefaultFullPgsqlRawMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.DefaultLastPgsqlRawContent;
import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.DefaultPgsqlRawContent;
import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.DefaultPgsqlRawMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgsqlRawPartDecoder
extends ByteToMessageDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PgsqlRawPartDecoder.class);
    private final String from;
    private final int maxlen;
    private AtomicInteger missing;
    private AtomicInteger expectedTypeSize;
    private AtomicInteger expectedHeaderSize;
    private AtomicReference<MsgHeaderParser> parser;

    public PgsqlRawPartDecoder(boolean frontend, int maxlen) {
        this.from = frontend ? "(F->)" : "(<-B)";
        this.maxlen = maxlen;
        this.missing = new AtomicInteger(0);
        this.expectedTypeSize = new AtomicInteger(0);
        this.expectedHeaderSize = new AtomicInteger(0);
        this.parser = new AtomicReference<FrontendFirstMsgHeaderParserImpl>((FrontendFirstMsgHeaderParserImpl)(frontend ? new FrontendFirstMsgHeaderParserImpl() : new BackendFirstMsgHeaderParserImpl()));
    }

    public void skipFirstMessages() {
        if (!(this.parser.get() instanceof MsgHeaderParserImpl)) {
            this.parser.set(new MsgHeaderParserImpl());
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        LOGGER.trace("{} Decoding {} bytes...", (Object)this.from, (Object)in.readableBytes());
        while (in.readableBytes() > 0) {
            if (this.missing.get() == 0) {
                if (in.readableBytes() < this.expectedHeaderSize.get()) {
                    return;
                }
                in.markReaderIndex();
                byte type = this.parser.get().getType(in);
                int length = this.parser.get().getLength(in);
                in.resetReaderIndex();
                ByteBuf bytes = in.readRetainedSlice(Math.min(Math.min(this.maxlen, in.readableBytes()), this.expectedTypeSize.get() + length));
                int m = this.expectedTypeSize.get() + length - bytes.readableBytes();
                this.missing.set(m);
                DefaultPgsqlRawMessage message = m == 0 ? new DefaultFullPgsqlRawMessage(bytes, type, length) : new DefaultPgsqlRawMessage(bytes, type, length);
                this.parser.get().postProcessing(type);
                out.add(message);
                LOGGER.trace("{} New {} raw message decoded: {}", new Object[]{this.from, m == 0 ? "full" : "partial", message});
                continue;
            }
            ByteBuf content = in.readRetainedSlice(Math.min(Math.min(this.maxlen, in.readableBytes()), this.missing.get()));
            int m = this.missing.addAndGet(-content.readableBytes());
            DefaultPgsqlRawContent message = m == 0 ? new DefaultLastPgsqlRawContent(content) : new DefaultPgsqlRawContent(content);
            out.add(message);
            LOGGER.trace("{} {} part of raw message decoded: {}", new Object[]{this.from, m == 0 ? "Last" : "New", message});
        }
        LOGGER.trace("{} Remain {} bytes to decode", (Object)this.from, (Object)in.readableBytes());
    }

    private class MsgHeaderParserImpl
    implements MsgHeaderParser {
        public MsgHeaderParserImpl() {
            PgsqlRawPartDecoder.this.expectedTypeSize.set(1);
            PgsqlRawPartDecoder.this.expectedHeaderSize.set(5);
        }

        @Override
        public byte getType(ByteBuf in) {
            return in.readByte();
        }

        @Override
        public int getLength(ByteBuf in) {
            return in.readInt();
        }

        @Override
        public void postProcessing(byte type) {
        }
    }

    private class BackendFirstMsgHeaderParserImpl
    implements MsgHeaderParser {
        public BackendFirstMsgHeaderParserImpl() {
            PgsqlRawPartDecoder.this.expectedTypeSize.set(0);
            PgsqlRawPartDecoder.this.expectedHeaderSize.set(0);
        }

        @Override
        public byte getType(ByteBuf in) {
            return -2;
        }

        @Override
        public int getLength(ByteBuf in) {
            return 1;
        }

        @Override
        public void postProcessing(byte type) {
            if (type == -2) {
                PgsqlRawPartDecoder.this.parser.set(new MsgHeaderParserImpl());
            }
        }
    }

    private class FrontendFirstMsgHeaderParserImpl
    implements MsgHeaderParser {
        private int length;

        public FrontendFirstMsgHeaderParserImpl() {
            PgsqlRawPartDecoder.this.expectedTypeSize.set(0);
            PgsqlRawPartDecoder.this.expectedHeaderSize.set(4);
        }

        @Override
        public byte getType(ByteBuf in) {
            int code;
            this.length = in.readInt();
            int type = 0;
            if (this.length == 8) {
                int code2 = in.readInt();
                if (code2 == 80877103) {
                    type = -1;
                }
            } else if (this.length == 16 && (code = in.readInt()) == 80877102) {
                type = -3;
            }
            return (byte)type;
        }

        @Override
        public int getLength(ByteBuf in) {
            return this.length;
        }

        @Override
        public void postProcessing(byte type) {
            if (type == 0) {
                PgsqlRawPartDecoder.this.parser.set(new MsgHeaderParserImpl());
            }
        }
    }

    private static interface MsgHeaderParser {
        public byte getType(ByteBuf var1);

        public int getLength(ByteBuf var1);

        public void postProcessing(byte var1);
    }
}

