/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.codec;

import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.FullPgsqlRawMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.LastPgsqlRawContent;
import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.PgsqlRawContent;
import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.PgsqlRawHeader;
import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.PgsqlRawPart;
import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.codec.DefaultMutablePgsqlRawMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.codec.MutablePgsqlRawMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.MessageAggregator;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgsqlRawPartAggregator
extends MessageAggregator<PgsqlRawPart, PgsqlRawHeader, PgsqlRawContent, MutablePgsqlRawMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PgsqlRawPartAggregator.class);
    private final int[] types;
    private byte currentType = (byte)-1;

    public PgsqlRawPartAggregator(int ... types) {
        super(Integer.MAX_VALUE);
        this.types = types;
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        if (!super.acceptInboundMessage(msg)) {
            return false;
        }
        if (msg instanceof PgsqlRawHeader) {
            this.currentType = ((PgsqlRawHeader)msg).getType();
        }
        boolean accept = Arrays.stream(this.types).anyMatch(type -> this.currentType == type);
        if (msg instanceof LastPgsqlRawContent) {
            this.currentType = (byte)-1;
        }
        return accept;
    }

    protected boolean isStartMessage(PgsqlRawPart msg) throws Exception {
        return msg instanceof PgsqlRawHeader;
    }

    protected boolean isContentMessage(PgsqlRawPart msg) throws Exception {
        return msg instanceof PgsqlRawContent;
    }

    protected boolean isLastContentMessage(PgsqlRawContent msg) throws Exception {
        return msg instanceof LastPgsqlRawContent;
    }

    protected boolean isAggregated(PgsqlRawPart msg) throws Exception {
        return msg instanceof FullPgsqlRawMessage;
    }

    protected boolean isContentLengthInvalid(PgsqlRawHeader start, int maxContentLength) throws Exception {
        return start.getTotalLength() > maxContentLength;
    }

    protected Object newContinueResponse(PgsqlRawHeader start, int maxContentLength, ChannelPipeline pipeline) throws Exception {
        return null;
    }

    protected boolean closeAfterContinueResponse(Object msg) throws Exception {
        return false;
    }

    protected boolean ignoreContentAfterContinueResponse(Object msg) throws Exception {
        return false;
    }

    protected MutablePgsqlRawMessage beginAggregation(PgsqlRawHeader start, ByteBuf content) throws Exception {
        LOGGER.trace("Start aggregation of header raw message {} with content {}...", (Object)start, (Object)content);
        DefaultMutablePgsqlRawMessage message = new DefaultMutablePgsqlRawMessage(content, start.getType(), start.getLength());
        LOGGER.trace("Aggregation of full raw message {} started", (Object)message);
        return message;
    }

    protected void aggregate(MutablePgsqlRawMessage msg, PgsqlRawContent content) throws Exception {
        LOGGER.trace("Continue aggregation of mutable raw message {} with content {}...", (Object)msg, (Object)content);
        LOGGER.trace("Aggregation of mutable raw message {} in progress", (Object)msg);
    }

    protected void finishAggregation(MutablePgsqlRawMessage msg) throws Exception {
        LOGGER.trace("Finish aggregation of mutable raw message {}...", (Object)msg);
        LOGGER.trace("Aggregation of mutable raw message {} completed", (Object)msg);
    }
}

