/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.codec;

import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.DefaultPgsqlRawMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.codec.MutablePgsqlRawMessage;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.StringUtil;

public class DefaultMutablePgsqlRawMessage
extends DefaultPgsqlRawMessage
implements MutablePgsqlRawMessage {
    private int missing;
    private int contentIndex;

    public DefaultMutablePgsqlRawMessage(ByteBuf bytes) {
        super(bytes);
    }

    public DefaultMutablePgsqlRawMessage(ByteBuf bytes, byte type, int length) {
        this(bytes, type, length, 0);
    }

    public DefaultMutablePgsqlRawMessage(ByteBuf bytes, byte type, int length, int missing) {
        super(bytes, type, length);
        this.setMissing(missing);
        this.contentIndex = bytes.readerIndex();
    }

    @Override
    public void setMissing(int missing) {
        this.missing = missing;
    }

    @Override
    public int getMissing() {
        return this.missing;
    }

    @Override
    public DefaultMutablePgsqlRawMessage replace(ByteBuf bytes) {
        return new DefaultMutablePgsqlRawMessage(bytes, this.getType(), this.getLength(), this.missing);
    }

    @Override
    public ByteBuf getContent() {
        return this.getBytes().slice(this.contentIndex + this.getHeaderSize(), this.getBytes().writerIndex() - this.contentIndex - this.getHeaderSize());
    }

    @Override
    public String toString() {
        return StringUtil.simpleClassName((Object)this) + "(bytes: " + this.getBytes().capacity() + ", type: " + (char)this.getType() + ", length: " + this.getLength() + ", missing: " + this.missing + ')';
    }
}

