/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.writer;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlStartupMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.writer.PgsqlMessageWriter;
import eu.clarussecure.proxy.spi.CString;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class PgsqlStartupMessageWriter
implements PgsqlMessageWriter<PgsqlStartupMessage> {
    @Override
    public int contentSize(PgsqlStartupMessage msg) {
        int size = 4;
        for (Map.Entry<CString, CString> parameter : msg.getParameters().entrySet()) {
            size += parameter.getKey().clen();
            size += parameter.getValue().clen();
        }
        return ++size;
    }

    @Override
    public Map<Integer, ByteBuf> offsets(PgsqlStartupMessage msg) {
        int firstPartSize = msg.getHeaderSize() + 4;
        LinkedHashMap<Integer, ByteBuf> offsets = new LinkedHashMap<Integer, ByteBuf>(msg.getParameters().size() * 2);
        int offset = firstPartSize;
        for (Map.Entry<CString, CString> entry : msg.getParameters().entrySet()) {
            offsets.put(offset, entry.getKey().getByteBuf());
            offsets.put(offset += entry.getKey().clen(), entry.getValue().getByteBuf());
            offset += entry.getValue().clen();
        }
        return offsets;
    }

    @Override
    public void writeHeader(PgsqlStartupMessage msg, int length, ByteBuf buffer) throws IOException {
        buffer.writeInt(length);
    }

    @Override
    public void writeContent(PgsqlStartupMessage msg, ByteBuf buffer) throws IOException {
        buffer.writeInt(msg.getProtocolVersion());
        for (Map.Entry<CString, CString> parameter : msg.getParameters().entrySet()) {
            ByteBuf key = parameter.getKey().getByteBuf();
            this.writeBytes(buffer, key);
            ByteBuf value = parameter.getValue().getByteBuf();
            this.writeBytes(buffer, value);
        }
        buffer.writeByte(0);
    }
}

