/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.writer;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlRowDescriptionMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.writer.PgsqlMessageWriter;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class PgsqlRowDescriptionMessageWriter
implements PgsqlMessageWriter<PgsqlRowDescriptionMessage> {
    @Override
    public int contentSize(PgsqlRowDescriptionMessage msg) {
        int size = 2;
        for (PgsqlRowDescriptionMessage.Field field : msg.getFields()) {
            size += field.getName().clen();
            size += 4;
            size += 2;
            size += 4;
            size += 2;
            size += 4;
            size += 2;
        }
        return size;
    }

    @Override
    public Map<Integer, ByteBuf> offsets(PgsqlRowDescriptionMessage msg) {
        int firstPartSize = msg.getHeaderSize();
        LinkedHashMap<Integer, ByteBuf> offsets = new LinkedHashMap<Integer, ByteBuf>(msg.getFields().size());
        int offset = firstPartSize += 2;
        for (PgsqlRowDescriptionMessage.Field field : msg.getFields()) {
            offsets.put(offset, field.getName().getByteBuf());
            offset += field.getName().clen();
            offset += 4;
            offset += 2;
            offset += 4;
            offset += 2;
            offset += 4;
            offset += 2;
        }
        return offsets;
    }

    @Override
    public void writeContent(PgsqlRowDescriptionMessage msg, ByteBuf buffer) throws IOException {
        buffer.writeShort(msg.getFields().size());
        for (PgsqlRowDescriptionMessage.Field field : msg.getFields()) {
            this.writeBytes(buffer, field.getName().getByteBuf());
            buffer.writeInt(field.getTableOID());
            buffer.writeShort((int)field.getColumnNumber());
            buffer.writeInt((int)field.getTypeOID());
            buffer.writeShort((int)field.getTypeSize());
            buffer.writeInt(field.getTypeModifier());
            buffer.writeShort((int)field.getFormat());
        }
    }
}

