/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.writer;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlMessage;
import eu.clarussecure.proxy.spi.buffer.ByteBufUtilities;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public interface PgsqlMessageWriter<T extends PgsqlMessage> {
    default public int length(T msg) {
        return this.headerSize(msg) + this.contentSize(msg);
    }

    default public int headerSize(T msg) {
        return msg.getHeaderSize();
    }

    default public int contentSize(T msg) {
        return 0;
    }

    default public ByteBuf allocate(T msg) {
        return this.allocate(msg, null);
    }

    default public ByteBuf allocate(T msg, ByteBuf buffer) {
        ByteBuf newBuffer;
        boolean alloc;
        int len = this.length(msg);
        Map<Integer, ByteBuf> offsets = this.offsets(msg);
        boolean bl = alloc = buffer == null || len > buffer.capacity();
        if (!alloc && buffer != null) {
            alloc = offsets.entrySet().stream().anyMatch(e -> !ByteBufUtilities.containsAt((ByteBuf)buffer, (ByteBuf)((ByteBuf)e.getValue()), (int)((Integer)e.getKey())));
        }
        if (alloc) {
            UnpooledByteBufAllocator allocator;
            Object object = allocator = buffer == null ? UnpooledByteBufAllocator.DEFAULT : buffer.alloc();
            if (offsets.isEmpty()) {
                newBuffer = allocator.buffer(len);
            } else {
                ArrayList<ByteBuf> components = new ArrayList<ByteBuf>(2 * offsets.size());
                int previousOffset = 0;
                for (Map.Entry<Integer, ByteBuf> entry : offsets.entrySet()) {
                    ByteBuf msgBuffer = entry.getValue();
                    if (msgBuffer.capacity() == 0) continue;
                    int offset = entry.getKey();
                    int intermediateSize = offset - previousOffset;
                    if (intermediateSize > 0) {
                        ByteBuf intermediateBuffer = allocator.buffer(intermediateSize).writerIndex(intermediateSize);
                        components.add(intermediateBuffer);
                    }
                    msgBuffer = msgBuffer.slice(0, msgBuffer.capacity());
                    components.add(msgBuffer);
                    previousOffset = offset + msgBuffer.capacity();
                }
                int intermediateSize = len - previousOffset;
                if (intermediateSize > 0) {
                    ByteBuf intermediateBuffer = allocator.buffer(intermediateSize).writerIndex(intermediateSize);
                    components.add(intermediateBuffer);
                }
                newBuffer = allocator.compositeBuffer(components.size()).addComponents(components);
            }
        } else {
            newBuffer = buffer.retainedSlice(0, len);
        }
        newBuffer.writerIndex(0);
        return newBuffer;
    }

    default public Map<Integer, ByteBuf> offsets(T msg) {
        return Collections.emptyMap();
    }

    default public ByteBuf write(T msg, ByteBuf buffer) throws IOException {
        int len = this.length(msg);
        if (buffer == null || buffer.writableBytes() < len) {
            UnpooledByteBufAllocator allocator = buffer == null ? UnpooledByteBufAllocator.DEFAULT : buffer.alloc();
            buffer = allocator.buffer(len);
        }
        this.writeHeader(msg, len, buffer);
        this.writeContent(msg, buffer);
        return buffer;
    }

    default public void writeHeader(T msg, int length, ByteBuf buffer) throws IOException {
        buffer.writeByte((int)msg.getType());
        buffer.writeInt(length - 1);
    }

    default public void writeContent(T msg, ByteBuf buffer) throws IOException {
    }

    default public ByteBuf writeBytes(ByteBuf dst, ByteBuf src) {
        return this.writeBytes(dst, src, true);
    }

    default public ByteBuf writeBytes(ByteBuf dst, ByteBuf src, boolean release) {
        boolean skipCopy = false;
        if (dst instanceof CompositeByteBuf) {
            ByteBuf buffer2;
            ByteBuf buffer1 = ((CompositeByteBuf)dst).internalComponentAtOffset(dst.writerIndex());
            skipCopy = (buffer1 = ByteBufUtilities.unwrap((ByteBuf)buffer1).unwrap()) == (buffer2 = ByteBufUtilities.unwrap((ByteBuf)src)) || buffer1 == buffer2.unwrap();
        } else {
            skipCopy = ByteBufUtilities.containsAt((ByteBuf)dst, (ByteBuf)src, (int)dst.writerIndex());
        }
        if (skipCopy) {
            dst.writerIndex(dst.writerIndex() + src.capacity());
        } else {
            dst.writeBytes(src, 0, src.capacity());
            if (release) {
                src.release();
            }
        }
        return dst;
    }
}

