/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.writer;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlDataRowMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.writer.PgsqlMessageWriter;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class PgsqlDataRowMessageWriter
implements PgsqlMessageWriter<PgsqlDataRowMessage> {
    @Override
    public int contentSize(PgsqlDataRowMessage msg) {
        int size = 2;
        for (ByteBuf value : msg.getValues()) {
            size += 4;
            if (value == null) continue;
            size += value.capacity();
        }
        return size;
    }

    @Override
    public Map<Integer, ByteBuf> offsets(PgsqlDataRowMessage msg) {
        int firstPartSize = msg.getHeaderSize();
        LinkedHashMap<Integer, ByteBuf> offsets = new LinkedHashMap<Integer, ByteBuf>(msg.getValues().size());
        int offset = firstPartSize += 2;
        for (ByteBuf value : msg.getValues()) {
            offset += 4;
            if (value == null) continue;
            offsets.put(offset, value);
            offset += value.capacity();
        }
        return offsets;
    }

    @Override
    public void writeContent(PgsqlDataRowMessage msg, ByteBuf buffer) throws IOException {
        buffer.writeShort(msg.getValues().size());
        for (ByteBuf value : msg.getValues()) {
            buffer.writeInt(value == null ? -1 : value.capacity());
            if (value == null) continue;
            this.writeBytes(buffer, value);
        }
    }
}

