/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.writer;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlAuthenticationResponse;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.writer.PgsqlMessageWriter;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgsqlAuthenticationResponseWriter
implements PgsqlMessageWriter<PgsqlAuthenticationResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PgsqlAuthenticationResponseWriter.class);

    @Override
    public int contentSize(PgsqlAuthenticationResponse msg) {
        int size = 4;
        if (msg.getAuthenticationParameters() != null) {
            size += msg.getAuthenticationParameters().readableBytes();
        }
        return size;
    }

    @Override
    public Map<Integer, ByteBuf> offsets(PgsqlAuthenticationResponse msg) {
        int headerSize;
        int offset = headerSize = msg.getHeaderSize();
        Map<Integer, ByteBuf> offsets = null;
        offsets = msg.getAuthenticationParameters() != null ? Collections.singletonMap(offset += 4, msg.getAuthenticationParameters()) : Collections.emptyMap();
        return offsets;
    }

    @Override
    public void writeContent(PgsqlAuthenticationResponse msg, ByteBuf buffer) throws IOException {
        LOGGER.debug("PgsqlAuthenticationResponseWriter authenticationtype: {}", (Object)msg.getAuthenticationType());
        buffer.writeInt(msg.getAuthenticationType());
        if (msg.getAuthenticationParameters() != null) {
            this.writeBytes(buffer, msg.getAuthenticationParameters());
        }
    }
}

