/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.data;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.data.GBox;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.data.PGArray;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.data.Type;
import eu.clarussecure.proxy.spi.CString;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import org.postgis.Geometry;
import org.postgis.PGbox2d;
import org.postgis.PGbox3d;
import org.postgis.binary.BinaryWriter;
import org.postgresql.jdbc.TimestampUtils;

public class TypeWriter {
    public static CString toCString(Type type, Object value) {
        if (type.isPGArray()) {
            return TypeWriter.toCString((PGArray)value, type);
        }
        return TypeWriter.toCString(value, type);
    }

    private static CString toCString(PGArray pgArray, Type type) {
        if (pgArray == null) {
            return null;
        }
        if (pgArray.getDims() != null && pgArray.getLbounds() != null) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < pgArray.getNdims(); ++i) {
                int lbound = pgArray.getLbounds()[i];
                int dim = pgArray.getDims()[i];
                buf.append('[').append(lbound).append(':').append(lbound + dim - 1).append(']');
            }
            buf.append('=');
            CString values = TypeWriter.toCString(pgArray.getArray(), type, pgArray.getSeparators(), 0);
            buf.append((CharSequence)values);
            return CString.valueOf((CharSequence)buf);
        }
        return TypeWriter.toCString(pgArray.getArray(), type, pgArray.getSeparators(), 0);
    }

    private static CString toCString(Object array, Type type, char[] separators, int level) {
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        if (array != null) {
            char separator = separators != null ? separators[level] : (char)',';
            int len = Array.getLength(array);
            for (int i = 0; i < len; ++i) {
                Object value;
                if (i > 0) {
                    buf.append(separator);
                }
                if ((value = Array.get(array, i)) == null) {
                    buf.append("NULL");
                    continue;
                }
                if (value.getClass().isArray()) {
                    buf.append((CharSequence)TypeWriter.toCString(array, type, separators, level));
                    continue;
                }
                if (value instanceof CString) {
                    buf.append('\"').append(value).append('\"');
                    continue;
                }
                buf.append(value);
            }
        }
        buf.append('}');
        return CString.valueOf((CharSequence)buf);
    }

    private static CString toCString(Object value, Type type) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case INT2: {
                return TypeWriter.toCString((Short)value);
            }
            case INT4: {
                return TypeWriter.toCString((Integer)value);
            }
            case INT8: {
                return TypeWriter.toCString((Long)value);
            }
            case TEXT: {
                return TypeWriter.toCString((CString)value);
            }
            case NUMERIC: {
                return TypeWriter.toCString((Number)value);
            }
            case FLOAT4: {
                return TypeWriter.toCString(((Float)value).floatValue());
            }
            case FLOAT8: {
                return TypeWriter.toCString((Double)value);
            }
            case BOOL: {
                return TypeWriter.toCString((Boolean)value);
            }
            case DATE: {
                return TypeWriter.toCString((Date)value);
            }
            case TIME: {
                return TypeWriter.toCString((Time)value);
            }
            case TIMETZ: {
                return TypeWriter.toCString((Time)value);
            }
            case TIMESTAMP: {
                return TypeWriter.toCString((Timestamp)value);
            }
            case TIMESTAMPTZ: {
                return TypeWriter.toCString((Timestamp)value);
            }
            case BYTEA: {
                return TypeWriter.toCString((ByteBuf)value);
            }
            case VARCHAR: {
                return TypeWriter.toCString((CString)value);
            }
            case OID: {
                return TypeWriter.toCString((Long)value & 0xFFFFL);
            }
            case BPCHAR: {
                return TypeWriter.toCString((CString)value);
            }
            case MONEY: {
                return TypeWriter.toCString((Double)value);
            }
            case NAME: {
                return TypeWriter.toCString((CString)value);
            }
            case BIT: {
                return TypeWriter.toCString((Boolean)value);
            }
            case CHAR: {
                return TypeWriter.toCString(((Character)value).charValue());
            }
            case GEOMETRY: {
                return TypeWriter.toCString((Geometry)value);
            }
            case BOX3D: {
                return TypeWriter.toCString((PGbox3d)value);
            }
            case BOX2D: {
                return TypeWriter.toCString((PGbox2d)value);
            }
        }
        return TypeWriter.toCString((CString)value);
    }

    private static CString toCString(ByteBuf buf) {
        return CString.valueOf((CharSequence)ByteBufUtil.hexDump((ByteBuf)buf, (int)0, (int)buf.capacity()));
    }

    private static CString toCString(short s) {
        return CString.valueOf((CharSequence)Short.toString(s));
    }

    private static CString toCString(int i) {
        return CString.valueOf((CharSequence)Integer.toString(i));
    }

    private static CString toCString(long l) {
        return CString.valueOf((CharSequence)Long.toString(l));
    }

    private static CString toCString(float f) {
        return CString.valueOf((CharSequence)Float.toString(f));
    }

    private static CString toCString(double f) {
        return CString.valueOf((CharSequence)Double.toString(f));
    }

    private static CString toCString(Number n) {
        return CString.valueOf((CharSequence)n.toString());
    }

    private static CString toCString(boolean b) {
        return CString.valueOf((CharSequence)(b ? "t" : "f"));
    }

    private static CString toCString(char c) {
        return CString.valueOf((CharSequence)Character.toString(c));
    }

    private static CString toCString(CString str) {
        return str;
    }

    private static CString toCString(Date date) {
        TimestampUtils timestampUtils = TypeWriter.buildTimestampUtils();
        return CString.valueOf((CharSequence)timestampUtils.toString(null, date));
    }

    private static CString toCString(Time time) {
        TimestampUtils timestampUtils = TypeWriter.buildTimestampUtils();
        return CString.valueOf((CharSequence)timestampUtils.toString(null, time));
    }

    private static CString toCString(Timestamp timestamp) {
        TimestampUtils timestampUtils = TypeWriter.buildTimestampUtils();
        return CString.valueOf((CharSequence)timestampUtils.toString(null, timestamp));
    }

    private static TimestampUtils buildTimestampUtils() {
        try {
            Constructor constructor = TimestampUtils.class.getConstructor(Boolean.TYPE, Boolean.TYPE);
            constructor.setAccessible(true);
            TimestampUtils timestampUtils = (TimestampUtils)constructor.newInstance(true, true);
            return timestampUtils;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static CString toCString(Geometry geometry) {
        return CString.valueOf((CharSequence)geometry.toString());
    }

    private static CString toCString(PGbox3d pgBox3d) {
        int srid = pgBox3d.getLLB().getSrid();
        String value = srid != 0 ? String.format("SRID=%d;%s", srid, pgBox3d.toString()) : pgBox3d.toString();
        return CString.valueOf((CharSequence)value);
    }

    private static CString toCString(PGbox2d pgBox2d) {
        int srid = pgBox2d.getLLB().getSrid();
        String value = srid != 0 ? String.format("SRID=%d;%s", srid, pgBox2d.toString()) : pgBox2d.toString();
        return CString.valueOf((CharSequence)value);
    }

    public static ByteBuf getBytes(Type type, Object value) {
        if (type.isPGArray()) {
            return TypeWriter.getBytes((PGArray)value, type);
        }
        return TypeWriter.getBytes(value, type);
    }

    private static ByteBuf getBytes(PGArray pgArray, Type type) {
        int i;
        if (pgArray == null) {
            return null;
        }
        int len = 12 + pgArray.getNdims() * 2 * 4;
        int nbElts = 0;
        if (pgArray.getNdims() > 0) {
            nbElts = 1;
            for (int i2 = 0; i2 < pgArray.getNdims(); ++i2) {
                nbElts *= pgArray.getDims()[i2];
            }
            int[] indexes = new int[pgArray.getNdims()];
            Arrays.fill(indexes, 0);
            for (int i3 = 0; i3 < nbElts; ++i3) {
                int n = i3;
                Object elt = pgArray.getArray();
                for (int j = 0; j < pgArray.getNdims(); ++j) {
                    int k = n / pgArray.getDims()[j];
                    elt = Array.get(elt, k);
                    n -= k * pgArray.getDims()[j];
                }
                int eltSize = TypeWriter.getLength(elt, type.getElementType());
                len += 4 + eltSize;
            }
        }
        UnpooledByteBufAllocator allocator = UnpooledByteBufAllocator.DEFAULT;
        ByteBuf buf = allocator.buffer(len);
        buf.writeInt(pgArray.getNdims());
        buf.writeInt(pgArray.isHasnull() ? 1 : 0);
        buf.writeInt((int)pgArray.getTypeOid());
        for (i = 0; i < pgArray.getNdims(); ++i) {
            buf.writeInt(pgArray.getDims()[i]);
            buf.writeInt(pgArray.getLbounds()[i]);
        }
        for (i = 0; i < nbElts; ++i) {
            int n = i;
            Object elt = pgArray.getArray();
            for (int j = 0; j < pgArray.getNdims(); ++j) {
                int k = n / pgArray.getDims()[j];
                elt = Array.get(elt, k);
                n -= k * pgArray.getDims()[j];
            }
            ByteBuf bytes = TypeWriter.getBytes(elt, type.getElementType());
            buf.writeInt(bytes == null ? 0 : bytes.capacity());
            if (bytes == null) continue;
            buf.writeBytes(bytes);
        }
        return buf;
    }

    private static int getLength(Object value, Type type) {
        if (value == null) {
            return 0;
        }
        switch (type) {
            case INT2: {
                return TypeWriter.getLength((Short)value);
            }
            case INT4: {
                return TypeWriter.getLength((Integer)value);
            }
            case INT8: {
                return TypeWriter.getLength((Long)value);
            }
            case TEXT: {
                return TypeWriter.getLength((CString)value);
            }
            case NUMERIC: {
                return TypeWriter.getLength((Number)value);
            }
            case FLOAT4: {
                return TypeWriter.getLength(((Float)value).floatValue());
            }
            case FLOAT8: {
                return TypeWriter.getLength((Double)value);
            }
            case BOOL: {
                return TypeWriter.getLength((Boolean)value);
            }
            case DATE: {
                return TypeWriter.getLength((Date)value);
            }
            case TIME: {
                return TypeWriter.getLength((Time)value);
            }
            case TIMETZ: {
                return TypeWriter.getLength((Time)value);
            }
            case TIMESTAMP: {
                return TypeWriter.getLength((Timestamp)value);
            }
            case TIMESTAMPTZ: {
                return TypeWriter.getLength((Timestamp)value);
            }
            case BYTEA: {
                return TypeWriter.getLength((ByteBuf)value);
            }
            case VARCHAR: {
                return TypeWriter.getLength((CString)value);
            }
            case OID: {
                return TypeWriter.getLength((Long)value & 0xFFFFL);
            }
            case BPCHAR: {
                return TypeWriter.getLength((CString)value);
            }
            case MONEY: {
                return TypeWriter.getLength((Double)value);
            }
            case NAME: {
                return TypeWriter.getLength((CString)value);
            }
            case BIT: {
                return TypeWriter.getLength((Boolean)value);
            }
            case CHAR: {
                return TypeWriter.getLength(((Character)value).charValue());
            }
            case GEOMETRY: {
                return TypeWriter.getLength((Geometry)value);
            }
            case BOX3D: {
                return TypeWriter.getLength((PGbox3d)value);
            }
            case BOX2D: {
                return TypeWriter.getLength((PGbox2d)value);
            }
        }
        return TypeWriter.getLength((CString)value);
    }

    private static ByteBuf getBytes(Object value, Type type) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case INT2: {
                return TypeWriter.getBytes((Short)value);
            }
            case INT4: {
                return TypeWriter.getBytes((Integer)value);
            }
            case INT8: {
                return TypeWriter.getBytes((Long)value);
            }
            case TEXT: {
                return TypeWriter.getBytes((CString)value);
            }
            case NUMERIC: {
                return TypeWriter.getBytes((Number)value);
            }
            case FLOAT4: {
                return TypeWriter.getBytes(((Float)value).floatValue());
            }
            case FLOAT8: {
                return TypeWriter.getBytes((Double)value);
            }
            case BOOL: {
                return TypeWriter.getBytes((Boolean)value);
            }
            case DATE: {
                return TypeWriter.getBytes((Date)value);
            }
            case TIME: {
                return TypeWriter.getBytes((Time)value);
            }
            case TIMETZ: {
                return TypeWriter.getBytes((Time)value);
            }
            case TIMESTAMP: {
                return TypeWriter.getBytes((Timestamp)value);
            }
            case TIMESTAMPTZ: {
                return TypeWriter.getBytes((Timestamp)value);
            }
            case BYTEA: {
                return TypeWriter.getBytes((ByteBuf)value);
            }
            case VARCHAR: {
                return TypeWriter.getBytes((CString)value);
            }
            case OID: {
                return TypeWriter.getBytes((int)((Long)value & 0xFFFFL));
            }
            case BPCHAR: {
                return TypeWriter.getBytes((CString)value);
            }
            case MONEY: {
                return TypeWriter.getBytes((Double)value);
            }
            case NAME: {
                return TypeWriter.getBytes((CString)value);
            }
            case BIT: {
                return TypeWriter.getBytes((Boolean)value);
            }
            case CHAR: {
                return TypeWriter.getBytes(((Character)value).charValue());
            }
            case GEOMETRY: {
                return TypeWriter.getBytes((Geometry)value);
            }
            case BOX3D: {
                return TypeWriter.getBytes((PGbox3d)value);
            }
            case BOX2D: {
                return TypeWriter.getBytes((PGbox2d)value);
            }
        }
        return TypeWriter.getBytes((CString)value);
    }

    private static int getLength(ByteBuf buf) {
        return buf != null ? buf.readableBytes() : 0;
    }

    private static ByteBuf getBytes(ByteBuf bytes) {
        return bytes;
    }

    private static int getLength(short s) {
        return 2;
    }

    private static ByteBuf getBytes(short s) {
        UnpooledByteBufAllocator allocator = UnpooledByteBufAllocator.DEFAULT;
        ByteBuf buf = allocator.buffer(TypeWriter.getLength(s));
        buf.writeShort((int)s);
        return buf;
    }

    private static int getLength(int i) {
        return 4;
    }

    private static ByteBuf getBytes(int i) {
        UnpooledByteBufAllocator allocator = UnpooledByteBufAllocator.DEFAULT;
        ByteBuf buf = allocator.buffer(TypeWriter.getLength(i));
        buf.writeInt(i);
        return buf;
    }

    private static int getLength(long l) {
        return 8;
    }

    private static ByteBuf getBytes(long l) {
        UnpooledByteBufAllocator allocator = UnpooledByteBufAllocator.DEFAULT;
        ByteBuf buf = allocator.buffer(TypeWriter.getLength(l));
        buf.writeLong(l);
        return buf;
    }

    private static int getLength(float f) {
        return 4;
    }

    private static ByteBuf getBytes(float f) {
        UnpooledByteBufAllocator allocator = UnpooledByteBufAllocator.DEFAULT;
        ByteBuf buf = allocator.buffer(TypeWriter.getLength(f));
        buf.writeFloat(f);
        return buf;
    }

    private static int getLength(double d) {
        return 8;
    }

    private static ByteBuf getBytes(double d) {
        UnpooledByteBufAllocator allocator = UnpooledByteBufAllocator.DEFAULT;
        ByteBuf buf = allocator.buffer(TypeWriter.getLength(d));
        buf.writeDouble(d);
        return buf;
    }

    private static int getLength(Number n) {
        return 0;
    }

    private static ByteBuf getBytes(Number n) {
        return null;
    }

    private static int getLength(boolean b) {
        return 1;
    }

    private static ByteBuf getBytes(boolean b) {
        UnpooledByteBufAllocator allocator = UnpooledByteBufAllocator.DEFAULT;
        ByteBuf buf = allocator.buffer(TypeWriter.getLength(b));
        buf.writeBoolean(b);
        return buf;
    }

    private static int getLength(char c) {
        return 1;
    }

    private static ByteBuf getBytes(char c) {
        UnpooledByteBufAllocator allocator = UnpooledByteBufAllocator.DEFAULT;
        ByteBuf buf = allocator.buffer(TypeWriter.getLength(c));
        buf.writeChar((int)c);
        return buf;
    }

    private static int getLength(CString s) {
        return s != null ? s.length() : 0;
    }

    private static ByteBuf getBytes(CString s) {
        return s.getByteBuf();
    }

    private static int getLength(Date date) {
        return 0;
    }

    private static ByteBuf getBytes(Date date) {
        return null;
    }

    private static int getLength(Time time) {
        return 0;
    }

    private static ByteBuf getBytes(Time time) {
        return null;
    }

    private static int getLength(Timestamp timestamp) {
        return 0;
    }

    private static ByteBuf getBytes(Timestamp timestamp) {
        return null;
    }

    private static int getLength(Geometry geometry) {
        return new BinaryWriter(){

            public int getLength(Geometry geometry) {
                return this.estimateBytes(geometry);
            }
        }.getLength(geometry);
    }

    private static ByteBuf getBytes(Geometry geometry) {
        byte[] bytes = new BinaryWriter().writeBinary(geometry);
        UnpooledByteBufAllocator allocator = UnpooledByteBufAllocator.DEFAULT;
        ByteBuf buf = allocator.buffer(bytes.length);
        buf.writeBytes(bytes);
        return buf;
    }

    private static int getLength(PGbox3d pgbox3d) {
        return 48;
    }

    private static ByteBuf getBytes(PGbox3d pgbox3d) {
        int len = TypeWriter.getLength(pgbox3d);
        UnpooledByteBufAllocator allocator = UnpooledByteBufAllocator.DEFAULT;
        ByteBuf buf = allocator.buffer(len);
        buf.writeDouble(pgbox3d.getLLB().getX());
        buf.writeDouble(pgbox3d.getLLB().getY());
        buf.writeDouble(pgbox3d.getLLB().getZ());
        buf.writeDouble(pgbox3d.getURT().getX());
        buf.writeDouble(pgbox3d.getURT().getY());
        buf.writeDouble(pgbox3d.getURT().getZ());
        return buf;
    }

    private static int getLength(GBox gbox) {
        return 65;
    }

    private static ByteBuf getBytes(GBox gbox) {
        int len = TypeWriter.getLength(gbox);
        UnpooledByteBufAllocator allocator = UnpooledByteBufAllocator.DEFAULT;
        ByteBuf buf = allocator.buffer(len);
        buf.writeByte((int)((byte)gbox.getFlags()));
        buf.writeDouble(gbox.getXmin());
        buf.writeDouble(gbox.getXmax());
        buf.writeDouble(gbox.getYmin());
        buf.writeDouble(gbox.getYmax());
        buf.writeDouble(gbox.getZmin());
        buf.writeDouble(gbox.getZmax());
        buf.writeDouble(gbox.getMmin());
        buf.writeDouble(gbox.getMmax());
        return buf;
    }

    private static int getLength(PGbox2d pgbox2d) {
        return TypeWriter.getLength((GBox)null);
    }

    private static ByteBuf getBytes(PGbox2d pgbox2d) {
        GBox gbox = new GBox(0, pgbox2d.getLLB().getX(), pgbox2d.getURT().getX(), pgbox2d.getLLB().getY(), pgbox2d.getURT().getY(), 0.0, 0.0, 0.0, 0.0);
        return TypeWriter.getBytes(gbox);
    }
}

