/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.data;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.data.GBox;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.data.PGArray;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.data.Type;
import eu.clarussecure.proxy.spi.CString;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import org.postgis.Geometry;
import org.postgis.PGbox2d;
import org.postgis.PGbox3d;
import org.postgis.PGgeometry;
import org.postgis.Point;
import org.postgis.binary.BinaryParser;
import org.postgresql.jdbc.TimestampUtils;

public class TypeParser {
    public static Object parse(Type type, int typeModifier, CString value) {
        if (type.isPGArray()) {
            return TypeParser.parsePGArray(value, type, typeModifier);
        }
        return TypeParser.parse(value, type, typeModifier);
    }

    private static PGArray parsePGArray(CString value, Type type, int typeModifier) {
        if (value == null) {
            return null;
        }
        int ndims = 1;
        long typeOid = type.getOid();
        int[] dims = null;
        int[] lbounds = null;
        char[] separators = null;
        if (value.length() > 0 && value.charAt(0) == '[') {
            int eq = value.indexOf(61);
            if (eq == -1) {
                throw new IllegalArgumentException(value.toString());
            }
            if (value.charAt(eq - 1) != ']') {
                throw new IllegalArgumentException(value.toString());
            }
            String[] strs = value.substring(0, eq).toString().split("[\\]\\[]");
            ndims = 0;
            for (String str : strs) {
                if (str.isEmpty()) continue;
                ++ndims;
            }
            dims = new int[ndims];
            lbounds = new int[ndims];
            separators = new char[ndims];
            int i = 0;
            for (String str : strs) {
                if (str.isEmpty()) continue;
                String[] strs2 = str.split(":");
                lbounds[i] = Integer.parseInt(strs2[0].toString());
                dims[i] = Integer.parseInt(strs2[1].toString()) - lbounds[i] + 1;
            }
            value = value.substring(eq + 1);
        }
        boolean[] hasnull = new boolean[]{false};
        Object array = TypeParser.parseArray(value, type, typeModifier, hasnull, separators, 0);
        return new PGArray(ndims, hasnull[0], typeOid, dims, lbounds, separators, array);
    }

    private static Object parseArray(CString value, Type type, int typeModifier, boolean[] hasnull, char[] separators, int level) {
        if (value.length() < 1 || value.charAt(0) != '{') {
            throw new IllegalArgumentException(value.toString());
        }
        if (value.length() < 2 || value.charAt(value.length() - 1) != '}') {
            throw new IllegalArgumentException(value.toString());
        }
        ArrayList<CString> subValues = new ArrayList<CString>();
        separators[level] = '\u0000';
        int begin = 1;
        boolean insideString = false;
        int insideCurlyBraces = 0;
        for (int i = 1; i < value.length() - 1; ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (insideCurlyBraces == 0) {
                if (!insideString) {
                    if (c == '{') {
                        ++insideCurlyBraces;
                        continue;
                    }
                    if (c == '\"') {
                        insideString = true;
                        continue;
                    }
                    if (c != ',' && c != ';') continue;
                    separators[level] = c;
                    subValues.add(value.substring(begin, i));
                    begin = i + 1;
                    continue;
                }
                if (c != '\"') continue;
                insideString = false;
                continue;
            }
            if (c == '{') {
                ++insideCurlyBraces;
                continue;
            }
            if (c != '}') continue;
            --insideCurlyBraces;
        }
        if (begin < value.length() - 1) {
            subValues.add(value.substring(begin, value.length() - 1));
        }
        Object array = null;
        for (int i = 0; i < subValues.size(); ++i) {
            Object elt;
            Object subValue = (CString)subValues.get(i);
            if (subValue.charAt(0) == '{') {
                elt = TypeParser.parseArray(subValue, type, typeModifier, hasnull, separators, level + 1);
            } else {
                subValue = subValue.equalsIgnoreCase((CharSequence)"NULL") ? null : (subValue.charAt(0) == '\"' && subValue.charAt(subValue.length() - 1) == '\"' ? subValue.substring(1, subValue.length() - 1) : subValue.replace((CharSequence)"\\", (CharSequence)""));
                elt = TypeParser.parse(subValue, type, typeModifier);
            }
            if (elt == null) {
                hasnull[0] = true;
            } else if (array == null) {
                array = Array.newInstance(elt.getClass(), subValues.size());
                for (int j = 0; j < i; ++j) {
                    Array.set(array, j, null);
                }
            }
            Array.set(array, i, elt);
        }
        return array;
    }

    private static Object parse(CString value, Type type, int typeModifier) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case INT2: {
                return TypeParser.parseShort(value);
            }
            case INT4: {
                return TypeParser.parseInteger(value);
            }
            case INT8: {
                return TypeParser.parseLong(value);
            }
            case TEXT: {
                return TypeParser.parseString(value);
            }
            case NUMERIC: {
                return TypeParser.parseBigDecimal(value, typeModifier == -1 ? -1 : typeModifier - 4 & 0xFFFF);
            }
            case FLOAT4: {
                return Float.valueOf(TypeParser.parseFloat(value));
            }
            case FLOAT8: {
                return TypeParser.parseDouble(value);
            }
            case BOOL: {
                return TypeParser.parseBoolean(value);
            }
            case DATE: {
                return TypeParser.parseDate(value);
            }
            case TIME: {
                return TypeParser.parseTime(value);
            }
            case TIMETZ: {
                return TypeParser.parseTime(value);
            }
            case TIMESTAMP: {
                return TypeParser.parseTimestamp(value);
            }
            case TIMESTAMPTZ: {
                return TypeParser.parseTimestamp(value);
            }
            case BYTEA: {
                return TypeParser.parseByteArray(value);
            }
            case VARCHAR: {
                return TypeParser.parseString(value);
            }
            case OID: {
                return (long)TypeParser.parseInteger(value) & 0xFFFFL;
            }
            case BPCHAR: {
                return TypeParser.parseString(value);
            }
            case MONEY: {
                return TypeParser.parseDouble(value);
            }
            case NAME: {
                return TypeParser.parseString(value);
            }
            case BIT: {
                return TypeParser.parseBoolean(value);
            }
            case CHAR: {
                return Character.valueOf(TypeParser.parseCharacter(value));
            }
            case GEOMETRY: {
                return TypeParser.parseGeometry(value);
            }
            case BOX3D: {
                return TypeParser.parsePGbox3d(value);
            }
            case BOX2D: {
                return TypeParser.parsePGbox2d(value);
            }
        }
        return TypeParser.parseString(value);
    }

    private static ByteBuf parseByteArray(CString value) {
        int len = value.length() / 2;
        UnpooledByteBufAllocator allocator = UnpooledByteBufAllocator.DEFAULT;
        ByteBuf buf = allocator.buffer(len);
        for (int i = 0; i < len; ++i) {
            int i2 = 2 * i;
            if (i2 + 1 > value.length()) {
                throw new IllegalArgumentException("Hex string has odd length");
            }
            int nib1 = TypeParser.hexToInt(value.charAt(i2));
            int nib0 = TypeParser.hexToInt(value.charAt(i2 + 1));
            byte b = (byte)((nib1 << 4) + (byte)nib0);
            buf.writeByte((int)b);
        }
        return buf;
    }

    private static int hexToInt(char hex) {
        int nib = Character.digit(hex, 16);
        if (nib < 0) {
            throw new IllegalArgumentException("Invalid hex digit: '" + hex + "'");
        }
        return nib;
    }

    private static short parseShort(CString value) {
        try {
            return Short.parseShort(value.toString());
        }
        catch (NumberFormatException e) {
            return TypeParser.parseBigInteger(value, 32768L, 32767L).shortValue();
        }
    }

    private static int parseInteger(CString value) {
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException e) {
            return TypeParser.parseBigInteger(value, Integer.MIN_VALUE, Integer.MAX_VALUE).intValue();
        }
    }

    private static long parseLong(CString value) {
        try {
            return Long.parseLong(value.toString());
        }
        catch (NumberFormatException e) {
            return TypeParser.parseBigInteger(value, Long.MIN_VALUE, Long.MAX_VALUE).longValue();
        }
    }

    private static BigInteger parseBigInteger(CString value, long min, long max) {
        BigInteger i = new BigDecimal(value.toString()).toBigInteger();
        int gt = i.compareTo(BigInteger.valueOf(max));
        int lt = i.compareTo(BigInteger.valueOf(min));
        if (gt > 0 || lt < 0) {
            throw new NumberFormatException(value.toString());
        }
        return i;
    }

    private static float parseFloat(CString value) {
        try {
            return Float.parseFloat(value.toString());
        }
        catch (NumberFormatException e) {
            return TypeParser.parseBigDecimal(value, 1.4E-45f, 3.4028234663852886E38).floatValue();
        }
    }

    private static double parseDouble(CString value) {
        try {
            return Double.parseDouble(value.toString());
        }
        catch (NumberFormatException e) {
            return TypeParser.parseBigDecimal(value, Double.MIN_VALUE, Double.MAX_VALUE).doubleValue();
        }
    }

    private static Number parseBigDecimal(CString value, int scale) {
        if (CString.valueOf((CharSequence)"NaN").equals((Object)value)) {
            return Double.NaN;
        }
        BigDecimal d = new BigDecimal(value.toString());
        if (scale != -1) {
            d = d.setScale(scale);
        }
        return d;
    }

    private static BigDecimal parseBigDecimal(CString value, double min, double max) {
        BigDecimal d = new BigDecimal(value.toString());
        int gt = d.compareTo(BigDecimal.valueOf(max));
        int lt = d.compareTo(BigDecimal.valueOf(min));
        if (gt > 0 || lt < 0) {
            throw new NumberFormatException(value.toString());
        }
        return d;
    }

    private static boolean parseBoolean(CString value) {
        if (value.equalsIgnoreCase((CharSequence)"t") || value.equalsIgnoreCase((CharSequence)"true") || value.equals((Object)"1")) {
            return true;
        }
        if (value.equalsIgnoreCase((CharSequence)"f") || value.equalsIgnoreCase((CharSequence)"false") || value.equals((Object)"0")) {
            return false;
        }
        try {
            return Double.valueOf(value.toString()) == 1.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static char parseCharacter(CString value) {
        return value.charAt(0);
    }

    private static CString parseString(CString value) {
        return value;
    }

    private static Date parseDate(CString value) {
        try {
            TimestampUtils timestampUtils = TypeParser.buildTimestampUtils();
            return timestampUtils.toDate(null, value.toString());
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private static Time parseTime(CString value) {
        try {
            TimestampUtils timestampUtils = TypeParser.buildTimestampUtils();
            return timestampUtils.toTime(null, value.toString());
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private static Timestamp parseTimestamp(CString value) {
        try {
            TimestampUtils timestampUtils = TypeParser.buildTimestampUtils();
            return timestampUtils.toTimestamp(null, value.toString());
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private static TimestampUtils buildTimestampUtils() {
        try {
            Constructor constructor = TimestampUtils.class.getConstructor(Boolean.TYPE, Boolean.TYPE);
            constructor.setAccessible(true);
            TimestampUtils timestampUtils = (TimestampUtils)constructor.newInstance(true, true);
            return timestampUtils;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Geometry parseGeometry(CString value) {
        try {
            return PGgeometry.geomFromString((String)value.toString());
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private static PGbox3d parsePGbox3d(CString value) {
        try {
            int index;
            String expected = new PGbox3d().getPrefix();
            String actual = value.toString();
            if (actual.startsWith("SRID=")) {
                String[] temp = PGgeometry.splitSRID((String)actual);
                actual = temp[1].trim();
            }
            if ((index = actual.indexOf(40)) == -1) {
                throw new IllegalArgumentException(String.format("value doesn't start with '%s('", expected));
            }
            if (!actual.substring(0, index).trim().equalsIgnoreCase(expected)) {
                throw new IllegalArgumentException(String.format("value doesn't start with '%s'", expected));
            }
            return new PGbox3d(value.toString());
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private static PGbox2d parsePGbox2d(CString value) {
        try {
            int index;
            String expected = new PGbox2d().getPrefix();
            String actual = value.toString();
            if (actual.startsWith("SRID=")) {
                String[] temp = PGgeometry.splitSRID((String)actual);
                actual = temp[1].trim();
            }
            if ((index = actual.indexOf(40)) == -1) {
                throw new IllegalArgumentException(String.format("value doesn't start with '%s('", expected));
            }
            if (!actual.substring(0, index).trim().equalsIgnoreCase(expected)) {
                throw new IllegalArgumentException(String.format("value doesn't start with '%s'", expected));
            }
            return new PGbox2d(value.toString());
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static Object parse(Type type, int typeModifier, ByteBuf value) {
        if (type.isPGArray()) {
            return TypeParser.parsePGArray(value, type, typeModifier);
        }
        return TypeParser.parse(value, type, typeModifier);
    }

    private static PGArray parsePGArray(ByteBuf value, Type type, int typeModifier) {
        if (value == null) {
            return null;
        }
        int ndims = value.readInt();
        int hasnull = value.readInt();
        int eltOid = value.readInt();
        if ((long)eltOid != type.getOid()) {
            throw new IllegalArgumentException("unexpected oid");
        }
        int nbElts = ndims == 0 ? 0 : 1;
        int[] dims = new int[ndims];
        int[] lbounds = new int[ndims];
        for (int i = 0; i < ndims; ++i) {
            dims[i] = value.readInt();
            nbElts *= dims[i];
            lbounds[i] = value.readInt();
        }
        Object array = ndims == 0 ? Array.newInstance(TypeParser.getJavaType(type.getElementType()), 0) : Array.newInstance(TypeParser.getJavaType(type.getElementType()), dims);
        Object[] currentArrays = new Object[ndims];
        currentArrays[0] = array;
        for (int i = 1; i < ndims; ++i) {
            currentArrays[i] = Array.get(currentArrays[i - 1], 0);
        }
        int[] currentIndexes = new int[ndims];
        Arrays.fill(currentIndexes, 0);
        block2: for (int i = 0; i < nbElts; ++i) {
            int eltSize = value.readInt();
            ByteBuf eltValue = value.readSlice(eltSize);
            Object o = TypeParser.parse(eltValue, type, typeModifier);
            Array.set(currentArrays[ndims - 1], currentIndexes[ndims - 1], o);
            for (int j = ndims - 1; j >= 0; --j) {
                int n = j;
                currentIndexes[n] = currentIndexes[n] + 1;
                if (currentIndexes[j] == dims[j]) {
                    currentIndexes[j] = 0;
                    continue;
                }
                for (int k = j; k < ndims - 1; ++k) {
                    currentArrays[k + 1] = Array.get(currentArrays[k], currentIndexes[k]);
                }
                continue block2;
            }
        }
        return new PGArray(ndims, hasnull != 0, eltOid, dims, lbounds, null, array);
    }

    private static Class<?> getJavaType(Type type) {
        switch (type) {
            case INT2: {
                return Short.TYPE;
            }
            case INT4: {
                return Integer.TYPE;
            }
            case INT8: {
                return Long.TYPE;
            }
            case TEXT: {
                return CString.class;
            }
            case NUMERIC: {
                return Number.class;
            }
            case FLOAT4: {
                return Float.TYPE;
            }
            case FLOAT8: {
                return Double.TYPE;
            }
            case BOOL: {
                return Boolean.TYPE;
            }
            case DATE: {
                return Date.class;
            }
            case TIME: {
                return Time.class;
            }
            case TIMETZ: {
                return Time.class;
            }
            case TIMESTAMP: {
                return Timestamp.class;
            }
            case TIMESTAMPTZ: {
                return Timestamp.class;
            }
            case BYTEA: {
                return ByteBuf.class;
            }
            case VARCHAR: {
                return CString.class;
            }
            case OID: {
                return Long.TYPE;
            }
            case BPCHAR: {
                return CString.class;
            }
            case MONEY: {
                return Double.TYPE;
            }
            case NAME: {
                return CString.class;
            }
            case BIT: {
                return Boolean.TYPE;
            }
            case CHAR: {
                return Character.TYPE;
            }
            case GEOMETRY: {
                return Geometry.class;
            }
            case BOX3D: {
                return PGbox3d.class;
            }
            case BOX2D: {
                return PGbox2d.class;
            }
        }
        return CString.class;
    }

    private static Object parse(ByteBuf value, Type type, int typeModifier) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case INT2: {
                return TypeParser.parseShort(value);
            }
            case INT4: {
                return TypeParser.parseInteger(value);
            }
            case INT8: {
                return TypeParser.parseLong(value);
            }
            case TEXT: {
                return TypeParser.parseString(value);
            }
            case NUMERIC: {
                return TypeParser.parseBigDecimal(value, typeModifier == -1 ? -1 : typeModifier - 4 & 0xFFFF);
            }
            case FLOAT4: {
                return Float.valueOf(TypeParser.parseFloat(value));
            }
            case FLOAT8: {
                return TypeParser.parseDouble(value);
            }
            case BOOL: {
                return TypeParser.parseBoolean(value);
            }
            case DATE: {
                return TypeParser.parseDate(value);
            }
            case TIME: {
                return TypeParser.parseTime(value);
            }
            case TIMETZ: {
                return TypeParser.parseTime(value);
            }
            case TIMESTAMP: {
                return TypeParser.parseTimestamp(value);
            }
            case TIMESTAMPTZ: {
                return TypeParser.parseTimestamp(value);
            }
            case BYTEA: {
                return TypeParser.parseByteArray(value);
            }
            case VARCHAR: {
                return TypeParser.parseString(value);
            }
            case OID: {
                return (long)TypeParser.parseInteger(value) & 0xFFFFL;
            }
            case BPCHAR: {
                return TypeParser.parseString(value);
            }
            case MONEY: {
                return TypeParser.parseDouble(value);
            }
            case NAME: {
                return TypeParser.parseString(value);
            }
            case BIT: {
                return TypeParser.parseBoolean(value);
            }
            case CHAR: {
                return Character.valueOf(TypeParser.parseCharacter(value));
            }
            case GEOMETRY: {
                return TypeParser.parseGeometry(value);
            }
            case BOX3D: {
                return TypeParser.parsePGbox3d(value);
            }
            case BOX2D: {
                return TypeParser.parsePGbox2d(value);
            }
        }
        return TypeParser.parseString(value);
    }

    private static ByteBuf parseByteArray(ByteBuf value) {
        return value;
    }

    private static short parseShort(ByteBuf value) {
        return value.readShort();
    }

    private static int parseInteger(ByteBuf value) {
        return value.readInt();
    }

    private static long parseLong(ByteBuf value) {
        return value.readLong();
    }

    private static float parseFloat(ByteBuf value) {
        return value.readFloat();
    }

    private static double parseDouble(ByteBuf value) {
        return value.readDouble();
    }

    private static Number parseBigDecimal(ByteBuf value, int scale) {
        int i;
        short ndigits = value.readShort();
        int weight = value.readShort();
        short sign = value.readShort();
        int dscale = value.readShort();
        if (sign == 49152) {
            return Double.NaN;
        }
        StringBuffer str = new StringBuffer();
        if (sign == 16384) {
            str.append('-');
        }
        if (weight < 0) {
            str.append('0');
            i = weight + 1;
        } else {
            for (i = 0; i <= weight; ++i) {
                short dig = i < ndigits ? value.readShort() : (short)0;
                boolean append = i > 0;
                for (int divisor = 1000; divisor > 1; divisor = (int)((short)(divisor / 10))) {
                    short d1 = (short)(dig / divisor);
                    dig = (short)(dig - d1 * divisor);
                    if (!(append |= d1 > 0)) continue;
                    str.append(48 + d1);
                }
                str.append(48 + dig);
            }
        }
        if (dscale > 0) {
            str.append('.');
            for (int j = 0; j < dscale; j += 4) {
                short dig = i > 0 && i < ndigits ? value.readShort() : (short)0;
                boolean append = false;
                for (int divisor = 1000; divisor > 1; divisor = (int)((short)(divisor / 10))) {
                    short d1 = (short)(dig / divisor);
                    dig = (short)(dig - d1 * divisor);
                    if (!(append |= d1 > 0)) continue;
                    str.append(48 + d1);
                }
                str.append(48 + dig);
                ++i;
            }
        }
        BigDecimal d = new BigDecimal(str.toString());
        if (scale != -1) {
            d = d.setScale(scale);
        }
        return d;
    }

    private static boolean parseBoolean(ByteBuf value) {
        return value.readBoolean();
    }

    private static char parseCharacter(ByteBuf value) {
        return value.readChar();
    }

    private static CString parseString(ByteBuf value) {
        return CString.valueOf((ByteBuf)value);
    }

    private static Date parseDate(ByteBuf value) {
        try {
            TimestampUtils timestampUtils = TypeParser.buildTimestampUtils();
            byte[] bytes = new byte[value.readableBytes()];
            value.readBytes(bytes);
            return timestampUtils.toDateBin(null, bytes);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private static Time parseTime(ByteBuf value) {
        try {
            TimestampUtils timestampUtils = TypeParser.buildTimestampUtils();
            byte[] bytes = new byte[value.readableBytes()];
            value.readBytes(bytes);
            return timestampUtils.toTimeBin(null, bytes);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private static Timestamp parseTimestamp(ByteBuf value) {
        try {
            TimestampUtils timestampUtils = TypeParser.buildTimestampUtils();
            byte[] bytes = new byte[value.readableBytes()];
            value.readBytes(bytes);
            return timestampUtils.toTimestampBin(null, bytes, false);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private static Geometry parseGeometry(ByteBuf value) {
        byte[] bytes = new byte[value.readableBytes()];
        value.readBytes(bytes);
        return new BinaryParser().parse(bytes);
    }

    private static PGbox3d parsePGbox3d(ByteBuf value) {
        double xmin = value.readDouble();
        double ymin = value.readDouble();
        double zmin = value.readDouble();
        double xmax = value.readDouble();
        double ymax = value.readDouble();
        double zmax = value.readDouble();
        int srid = value.readInt();
        Point llb = new Point(xmin, ymin, zmin);
        llb.setSrid(srid);
        Point urt = new Point(xmax, ymax, zmax);
        urt.setSrid(srid);
        return new PGbox3d(llb, urt);
    }

    private static PGbox2d parsePGbox2d(ByteBuf value) {
        GBox gbox = TypeParser.parseGBox(value);
        Point llb = new Point(gbox.getXmin(), gbox.getYmin());
        Point urt = new Point(gbox.getXmax(), gbox.getYmax());
        return new PGbox2d(llb, urt);
    }

    private static GBox parseGBox(ByteBuf value) {
        short flags = (short)(value.readByte() & 0xFF);
        double xmin = value.readDouble();
        double xmax = value.readDouble();
        double ymin = value.readDouble();
        double ymax = value.readDouble();
        double zmin = value.readDouble();
        double zmax = value.readDouble();
        double mmin = value.readDouble();
        double mmax = value.readDouble();
        return new GBox(flags, xmin, xmax, ymin, ymax, zmin, zmax, mmin, mmax);
    }
}

