/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLCommandType;
import eu.clarussecure.proxy.spi.CString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class SimpleSQLParserUtil {
    private static final Pattern INTEGER_PATTERN = Pattern.compile("\\d+");
    private static final Pattern WORD_PATTERN = Pattern.compile("[\\w_]+");
    private static Map<SQLCommandType, String[]> typeTokens = new HashMap<SQLCommandType, String[]>();

    public static SQLCommandType parse(CString sql) {
        SQLCommandType[] types = SQLCommandType.values();
        MutableInt index = new MutableInt(0);
        int start = 0;
        int end = 0;
        while (types.length > 1 || types.length == 1 && index.getValue() < SimpleSQLParserUtil.getTokens(types[0]).length) {
            start = SimpleSQLParserUtil.nextUncommentedLinePosition(sql, end);
            end = SimpleSQLParserUtil.nextTokenEndPosition(sql, start = SimpleSQLParserUtil.nextTokenStartPosition(sql, start));
            if (end > start) {
                CString nextStmtToken = sql.subSequence(start, end);
                SQLCommandType[] res = (SQLCommandType[])Arrays.stream(types).filter(type -> {
                    String token;
                    while ((token = SimpleSQLParserUtil.getToken(type, index.getValue())) != null) {
                        if (token.length() == 1 && token.charAt(0) == '*') {
                            return WORD_PATTERN.matcher((CharSequence)nextStmtToken).matches();
                        }
                        if (token.equals("\\d*")) {
                            return INTEGER_PATTERN.matcher((CharSequence)nextStmtToken).matches();
                        }
                        if (token.length() <= 2 || token.charAt(0) != '[' || token.charAt(token.length() - 1) != ']') break;
                        if (!nextStmtToken.equalsIgnoreCase((CharSequence)(token = token.substring(1, token.length() - 1)))) {
                            index.increment();
                            continue;
                        }
                        return true;
                    }
                    return nextStmtToken.equalsIgnoreCase((CharSequence)token);
                }).toArray(SQLCommandType[]::new);
                if (res.length == 0) {
                    res = (SQLCommandType[])Arrays.stream(types).filter(type -> SimpleSQLParserUtil.getToken(type, index.getValue()) == null).toArray(SQLCommandType[]::new);
                }
                types = res;
                index.increment();
                continue;
            }
            types = new SQLCommandType[]{};
        }
        if (types.length == 1) {
            return types[0];
        }
        return null;
    }

    private static int nextUncommentedLinePosition(CString statement, int offset) {
        while (statement.startsWith((CharSequence)"--", offset)) {
            ++offset;
            boolean eol = false;
            while (!eol && ++offset < statement.length()) {
                char c = statement.charAt(offset);
                while (c == '\r' || c == '\n' || c == '\f' || Character.getType(c) == 13) {
                    eol = true;
                    c = ++offset < statement.length() ? statement.charAt(offset) : (char)'\u0000';
                }
            }
        }
        return offset;
    }

    private static int nextTokenStartPosition(CString statement, int offset) {
        char c;
        while (offset < statement.length() && Character.isWhitespace(c = statement.charAt(offset))) {
            ++offset;
        }
        return offset;
    }

    private static int nextTokenEndPosition(CString statement, int offset) {
        char c;
        while (offset < statement.length() && !Character.isWhitespace(c = statement.charAt(offset)) && c != ';' && c != '(') {
            ++offset;
        }
        return offset;
    }

    private static String getToken(SQLCommandType type, int index) {
        String[] tokens = SimpleSQLParserUtil.getTokens(type);
        return tokens.length > index ? tokens[index] : null;
    }

    private static String[] getTokens(SQLCommandType type) {
        String[] tokens = typeTokens.get((Object)type);
        if (tokens == null) {
            String pattern = type.getPattern();
            tokens = pattern.split(" ");
            typeTokens.put(type, tokens);
        }
        return tokens;
    }

    private static class MutableInt {
        private int value;

        public MutableInt(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void increment() {
            ++this.value;
        }
    }
}

