/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.data.Types;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class SQLDatabaseSchema {
    private Map<String, List<String>> datasetDefinitions;
    private Map<String, String> datasetSrids;
    private Map<Long, SortedSet<Integer>> typeOIDBackends;
    private SortedMap<Integer, Types> backendTypes;
    private Types types;

    public Map<String, List<String>> getDatasetDefinitions() {
        if (this.datasetDefinitions == null) {
            this.datasetDefinitions = Collections.synchronizedMap(new HashMap());
        }
        return this.datasetDefinitions;
    }

    public void setDatasetDefinitions(Map<String, List<String>> datasetDefinitions) {
        this.datasetDefinitions = datasetDefinitions;
    }

    public void addDatasetDefinition(String datasetId, List<String> dataIds) {
        if (datasetId.endsWith("/")) {
            datasetId = datasetId.substring(0, datasetId.length() - 1);
        }
        this.getDatasetDefinitions().put(datasetId, dataIds);
    }

    public void removeDatasetDefinition(String datasetId) {
        if (datasetId.endsWith("/")) {
            datasetId = datasetId.substring(0, datasetId.length() - 1);
        }
        this.getDatasetDefinitions().remove(datasetId);
    }

    public void resetDatasetDefinition() {
        if (this.datasetDefinitions != null) {
            this.datasetDefinitions.clear();
        }
    }

    public List<String> getDatasetDefinition(String datasetId) {
        if (datasetId.endsWith("/")) {
            datasetId = datasetId.substring(0, datasetId.length() - 1);
        }
        return this.getDatasetDefinitions().get(datasetId);
    }

    public Map<String, String> getDatasetSrids() {
        if (this.datasetSrids == null) {
            this.datasetSrids = Collections.synchronizedMap(new HashMap());
        }
        return this.datasetSrids;
    }

    public void setDatasetSrids(Map<String, String> datasetSrids) {
        this.datasetSrids = datasetSrids;
    }

    public void addDatasetSrid(String datasetId, String srid) {
        if (datasetId.endsWith("/")) {
            datasetId = datasetId.substring(0, datasetId.length() - 1);
        }
        this.getDatasetSrids().put(datasetId, srid);
    }

    public void removeDatasetSrid(String datasetId) {
        if (datasetId.endsWith("/")) {
            datasetId = datasetId.substring(0, datasetId.length() - 1);
        }
        this.getDatasetSrids().remove(datasetId);
    }

    public void resetDatasetSrids() {
        if (this.datasetSrids != null) {
            this.datasetSrids.clear();
        }
    }

    public String getDatasetSrid(String datasetId) {
        if (datasetId.endsWith("/")) {
            datasetId = datasetId.substring(0, datasetId.length() - 1);
        }
        return this.getDatasetSrids().get(datasetId);
    }

    public Map<Long, SortedSet<Integer>> getTypeOIDBackends() {
        if (this.typeOIDBackends == null) {
            this.typeOIDBackends = new ConcurrentHashMap<Long, SortedSet<Integer>>();
        }
        return this.typeOIDBackends;
    }

    public void setTypeOIDBackends(Map<Long, SortedSet<Integer>> typeOIDBackends) {
        this.typeOIDBackends = typeOIDBackends;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypeOIDBackend(long typeOID, int backend) {
        SortedSet<Integer> backends = this.getTypeOIDBackends().get(typeOID);
        if (backends == null) {
            Map<Long, SortedSet<Integer>> map = this.getTypeOIDBackends();
            synchronized (map) {
                backends = this.getTypeOIDBackends().get(typeOID);
                if (backends == null) {
                    backends = new TreeSet<Integer>();
                    this.getTypeOIDBackends().put(typeOID, backends);
                }
            }
        }
        backends.add(backend);
    }

    public SortedSet<Integer> getTypeOIDBackends(long typeOID) {
        return this.getTypeOIDBackends().get(typeOID);
    }

    public synchronized SortedMap<Integer, Types> getAllBackendTypes() {
        if (this.backendTypes == null) {
            this.backendTypes = new TreeMap<Integer, Types>();
        }
        return this.backendTypes;
    }

    public synchronized Types getBackendTypes(int backend) {
        Types types = this.getAllBackendTypes().computeIfAbsent(backend, k -> new Types());
        return types;
    }

    public synchronized void setBackendTypes(SortedMap<Integer, Types> backendTypes) {
        this.backendTypes = backendTypes;
    }

    public void resetBackendTypes() {
        this.backendTypes = null;
    }

    public synchronized Types getTypes() {
        if (this.types == null) {
            this.types = new Types();
        }
        return this.types;
    }

    public synchronized void setTypes(Types types) {
        this.types = types;
    }
}

