/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.parser;

import eu.clarussecure.proxy.protocol.plugins.pgsql.PgsqlUtilities;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlBindMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.parser.PgsqlMessageParser;
import eu.clarussecure.proxy.spi.CString;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;

public class PgsqlBindMessageParser
implements PgsqlMessageParser<PgsqlBindMessage> {
    @Override
    public PgsqlBindMessage parse(ByteBuf content) throws IOException {
        short nbResultColumnFormats;
        short nbParameterValues;
        short nbParameterFormats;
        CString portal = PgsqlUtilities.getCString(content);
        CString preparedStatement = PgsqlUtilities.getCString(content);
        ArrayList<Short> parameterFormats = new ArrayList<Short>(nbParameterFormats);
        for (nbParameterFormats = content.readShort(); nbParameterFormats > 0; nbParameterFormats = (short)(nbParameterFormats - 1)) {
            parameterFormats.add(content.readShort());
        }
        ArrayList<ByteBuf> parameterValues = new ArrayList<ByteBuf>(nbParameterValues);
        for (nbParameterValues = content.readShort(); nbParameterValues > 0; nbParameterValues = (short)(nbParameterValues - 1)) {
            int length = content.readInt();
            parameterValues.add(length != -1 ? content.readSlice(length) : null);
        }
        ArrayList<Short> resultColumnFormats = new ArrayList<Short>(nbResultColumnFormats);
        for (nbResultColumnFormats = content.readShort(); nbResultColumnFormats > 0; nbResultColumnFormats = (short)(nbResultColumnFormats - 1)) {
            resultColumnFormats.add(content.readShort());
        }
        return new PgsqlBindMessage(portal, preparedStatement, parameterFormats, parameterValues, resultColumnFormats);
    }
}

