/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlMessageHandler;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlSSLResponseMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlSessionInitializationResponseMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.ssl.SessionInitializer;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.ssl.SessionMessageTransferMode;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionInitializationResponseHandler
extends PgsqlMessageHandler<PgsqlSessionInitializationResponseMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionInitializationResponseHandler.class);

    public SessionInitializationResponseHandler() {
        super(PgsqlSSLResponseMessage.class);
    }

    @Override
    protected PgsqlSessionInitializationResponseMessage process(ChannelHandlerContext ctx, PgsqlSessionInitializationResponseMessage msg) throws IOException {
        PgsqlSessionInitializationResponseMessage newMsg = msg;
        if (msg instanceof PgsqlSSLResponseMessage) {
            byte code = ((PgsqlSSLResponseMessage)msg).getCode();
            LOGGER.debug("SSL response: {}", (Object)code);
            SessionMessageTransferMode<Byte, Void> transferMode = this.getSessionInitializer(ctx).processSSLResponse(ctx, ((PgsqlSSLResponseMessage)msg).getCode());
            switch (transferMode.getTransferMode()) {
                case FORWARD: {
                    if (transferMode.getNewDetails() != code) {
                        LOGGER.trace("Modify the SSL response");
                        newMsg = new PgsqlSSLResponseMessage(transferMode.getNewDetails());
                    }
                    LOGGER.trace("Forward the SSL response");
                    break;
                }
                case FORGET: {
                    LOGGER.trace("Ignore the SSL response");
                    newMsg = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid value for enum " + ((Object)((Object)transferMode.getTransferMode())).getClass().getSimpleName() + ": " + (Object)((Object)transferMode.getTransferMode()));
                }
            }
        }
        return newMsg;
    }

    private SessionInitializer getSessionInitializer(ChannelHandlerContext ctx) {
        return this.getPgsqlSession(ctx).getSessionInitializer();
    }
}

