/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlBindCompleteMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlCloseCompleteMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlCommandCompleteMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlDataRowMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlDetailedQueryResponseMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlEmptyQueryMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlErrorMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlMessageHandler;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlNoDataMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlParameterDescriptionMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlParseCompleteMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlPortalSuspendedMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlQueryResponseMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlReadyForQueryMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlRowDescriptionMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.MessageTransferMode;
import eu.clarussecure.proxy.spi.CString;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResponseHandler
extends PgsqlMessageHandler<PgsqlQueryResponseMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryResponseHandler.class);

    public QueryResponseHandler() {
        super(PgsqlParseCompleteMessage.class, PgsqlBindCompleteMessage.class, PgsqlParameterDescriptionMessage.class, PgsqlRowDescriptionMessage.class, PgsqlDataRowMessage.class, PgsqlNoDataMessage.class, PgsqlCommandCompleteMessage.class, PgsqlEmptyQueryMessage.class, PgsqlPortalSuspendedMessage.class, PgsqlErrorMessage.class, PgsqlCloseCompleteMessage.class, PgsqlReadyForQueryMessage.class);
    }

    @Override
    protected PgsqlQueryResponseMessage process(ChannelHandlerContext ctx, PgsqlQueryResponseMessage msg) throws IOException {
        switch (msg.getType()) {
            case 49: {
                return this.process(ctx, (PgsqlParseCompleteMessage)msg, "Parse complete", () -> this.getEventProcessor(ctx).processParseCompleteResponse(ctx));
            }
            case 50: {
                return this.process(ctx, (PgsqlBindCompleteMessage)msg, "Bind complete", () -> this.getEventProcessor(ctx).processBindCompleteResponse(ctx));
            }
            case 116: {
                return this.processDetails(ctx, (PgsqlParameterDescriptionMessage)msg, "Parameter description", types -> this.getEventProcessor(ctx).processParameterDescriptionResponse(ctx, (List<Long>)types), PgsqlParameterDescriptionMessage::new);
            }
            case 84: {
                return this.processDetails(ctx, (PgsqlRowDescriptionMessage)msg, "Row description", fields -> this.getEventProcessor(ctx).processRowDescriptionResponse(ctx, (List<PgsqlRowDescriptionMessage.Field>)fields), PgsqlRowDescriptionMessage::new);
            }
            case 68: {
                return this.processDetails(ctx, (PgsqlDataRowMessage)msg, "Data row", values -> this.getEventProcessor(ctx).processDataRowResponse(ctx, (List<ByteBuf>)values), PgsqlDataRowMessage::new);
            }
            case 110: {
                return this.process(ctx, (PgsqlNoDataMessage)msg, "No data", () -> this.getEventProcessor(ctx).processNoDataResponse(ctx));
            }
            case 67: {
                return this.processDetails(ctx, (PgsqlCommandCompleteMessage)msg, "Command complete", fields -> this.getEventProcessor(ctx).processCommandCompleteResult(ctx, (CString)fields), PgsqlCommandCompleteMessage::new);
            }
            case 73: {
                return this.process(ctx, (PgsqlEmptyQueryMessage)msg, "Empty query", () -> this.getEventProcessor(ctx).processEmptyQueryResponse(ctx));
            }
            case 115: {
                return this.process(ctx, (PgsqlPortalSuspendedMessage)msg, "Portal suspended", () -> this.getEventProcessor(ctx).processPortalSuspendedResponse(ctx));
            }
            case 69: {
                PgsqlErrorMessage newMsg = this.processDetails(ctx, (PgsqlErrorMessage)msg, "Error", fields -> this.getEventProcessor(ctx).processErrorResult(ctx, (Map<Byte, CString>)fields), fields -> new PgsqlErrorMessage((Map<Byte, CString>)fields));
                return newMsg;
            }
            case 51: {
                return this.process(ctx, (PgsqlCloseCompleteMessage)msg, "Close complete", () -> this.getEventProcessor(ctx).processCloseCompleteResponse(ctx));
            }
            case 90: {
                PgsqlReadyForQueryMessage newMsg = this.processDetails(ctx, (PgsqlReadyForQueryMessage)msg, "Ready for query", trxStatus -> this.getEventProcessor(ctx).processReadyForQueryResponse(ctx, (Byte)trxStatus), PgsqlReadyForQueryMessage::new);
                return newMsg;
            }
        }
        throw new IllegalArgumentException(String.format("msg type %c", Character.valueOf((char)msg.getType())));
    }

    private <M extends PgsqlQueryResponseMessage> M process(ChannelHandlerContext ctx, M msg, String prefix, CheckedSupplier<MessageTransferMode<Void, Void>> processor) throws IOException {
        M newMsg = msg;
        LOGGER.debug("{}:", (Object)prefix);
        if (!this.process(ctx, processor)) {
            newMsg = null;
            LOGGER.trace("{} dropped", (Object)prefix);
        }
        return newMsg;
    }

    @Override
    private boolean process(ChannelHandlerContext ctx, CheckedSupplier<MessageTransferMode<Void, Void>> processor) throws IOException {
        MessageTransferMode<Void, Void> transferMode = processor.get();
        switch (transferMode.getTransferMode()) {
            case FORWARD: {
                return true;
            }
            case FORGET: {
                return false;
            }
        }
        throw new IllegalArgumentException("Invalid value for enum " + ((Object)((Object)transferMode.getTransferMode())).getClass().getSimpleName() + ": " + (Object)((Object)transferMode.getTransferMode()));
    }

    private <M extends PgsqlDetailedQueryResponseMessage<D>, D> M processDetails(ChannelHandlerContext ctx, M msg, String prefix, CheckedFunction<D, MessageTransferMode<D, Void>> processor, Function<D, M> builder) throws IOException {
        D details = msg.getDetails();
        Object newMsg = msg;
        LOGGER.debug("{}: {}", (Object)prefix, details);
        D newDetails = this.processDetails(ctx, details, processor);
        if (newDetails != details) {
            if (newDetails == null) {
                newMsg = null;
                LOGGER.trace("{} dropped", (Object)prefix);
            } else {
                newMsg = (PgsqlDetailedQueryResponseMessage)builder.apply(newDetails);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Query response modified: original was {}: {}", (Object)prefix, details);
                    LOGGER.trace("Query response modified: new is {}: {}", (Object)prefix, newDetails);
                }
            }
        }
        return newMsg;
    }

    private <D> D processDetails(ChannelHandlerContext ctx, D details, CheckedFunction<D, MessageTransferMode<D, Void>> processor) throws IOException {
        D newDetails;
        MessageTransferMode<D, Void> transferMode = processor.apply(details);
        switch (transferMode.getTransferMode()) {
            case FORWARD: {
                newDetails = transferMode.getNewContent();
                break;
            }
            case FORGET: {
                newDetails = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for enum " + ((Object)((Object)transferMode.getTransferMode())).getClass().getSimpleName() + ": " + (Object)((Object)transferMode.getTransferMode()));
            }
        }
        return newDetails;
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws IOException;
    }

    @FunctionalInterface
    public static interface CheckedSupplier<R> {
        public R get() throws IOException;
    }
}

