/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlDetailedQueryResponseMessage;
import io.netty.util.internal.StringUtil;

public class PgsqlReadyForQueryMessage
extends PgsqlDetailedQueryResponseMessage<Byte> {
    public static final byte TYPE = 90;
    private byte transactionStatus;

    public PgsqlReadyForQueryMessage(byte transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public String getTransactionStatusAsString() {
        switch ((char)this.transactionStatus) {
            case 'T': {
                return "In a transaction";
            }
            case 'I': {
                return "Idle-not in transaction";
            }
            case 'E': {
                return "Failed transaction block";
            }
        }
        throw new IllegalArgumentException(String.format("Invalid transaction status indicator '%c'", Character.valueOf((char)this.transactionStatus)));
    }

    public byte getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(byte trxStatus) {
        this.transactionStatus = trxStatus;
    }

    @Override
    public byte getType() {
        return 90;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(StringUtil.simpleClassName((Object)this));
        builder.append(" [");
        builder.append("transactionStatus=").append(this.transactionStatus).append(':').append(this.getTransactionStatusAsString());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Byte getDetails() {
        return this.getTransactionStatus();
    }
}

