/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlDetailedQueryResponseMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.Objects;

public class PgsqlDataRowMessage
extends PgsqlDetailedQueryResponseMessage<List<ByteBuf>> {
    public static final byte TYPE = 68;
    private List<ByteBuf> values;

    public PgsqlDataRowMessage(List<ByteBuf> values) {
        this.values = Objects.requireNonNull(values, "values must not be null");
    }

    public List<ByteBuf> getValues() {
        return this.values;
    }

    public void setValues(List<ByteBuf> values) {
        this.values = Objects.requireNonNull(values, "values must not be null");
    }

    @Override
    public byte getType() {
        return 68;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(StringUtil.simpleClassName((Object)this));
        builder.append(" [");
        builder.append("values=");
        int i = 0;
        for (ByteBuf value : this.values) {
            builder.append(ByteBufUtil.hexDump((ByteBuf)value, (int)0, (int)value.capacity()));
            if (++i >= this.values.size()) continue;
            builder.append('\n');
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public List<ByteBuf> getDetails() {
        return this.getValues();
    }
}

