/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlQueryRequestMessage;
import eu.clarussecure.proxy.spi.CString;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.Objects;

public class PgsqlBindMessage
extends PgsqlQueryRequestMessage {
    public static final byte TYPE = 66;
    private CString portal;
    private CString preparedStatement;
    private List<Short> parameterFormats;
    private List<ByteBuf> parameterValues;
    private List<Short> resultColumnFormats;

    public PgsqlBindMessage(CString portal, CString preparedStatement, List<Short> parameterFormats, List<ByteBuf> parameterValues, List<Short> resultColumnFormats) {
        this.portal = Objects.requireNonNull(portal, "portal must not be null");
        this.preparedStatement = Objects.requireNonNull(preparedStatement, "preparedStatement must not be null");
        this.parameterFormats = Objects.requireNonNull(parameterFormats, "parameterFormats must not be null");
        this.parameterValues = Objects.requireNonNull(parameterValues, "parameterValues must not be null");
        this.resultColumnFormats = Objects.requireNonNull(resultColumnFormats, "resultColumnFormats must not be null");
    }

    public CString getPortal() {
        return this.portal;
    }

    public void setPortal(CString portal) {
        this.portal = Objects.requireNonNull(portal, "portal must not be null");
    }

    public CString getPreparedStatement() {
        return this.preparedStatement;
    }

    public void setPreparedStatement(CString preparedStatement) {
        this.preparedStatement = Objects.requireNonNull(preparedStatement, "preparedStatement must not be null");
    }

    public List<Short> getParameterFormats() {
        return this.parameterFormats;
    }

    public void setParameterFormats(List<Short> parameterFormats) {
        this.parameterFormats = Objects.requireNonNull(parameterFormats, "parameterFormats must not be null");
    }

    public short getParameterFormat(int index) {
        switch (this.parameterFormats.size()) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.parameterFormats.get(0);
            }
        }
        return this.parameterFormats.get(index);
    }

    public boolean isParameterTextFormat(int index) {
        return this.getParameterFormat(index) == 0;
    }

    public boolean isParameterBinaryFormat(int index) {
        return this.getParameterFormat(index) == 1;
    }

    public List<ByteBuf> getParameterValues() {
        return this.parameterValues;
    }

    public void setParameterValues(List<ByteBuf> parameterValues) {
        this.parameterValues = Objects.requireNonNull(parameterValues, "parameterValues must not be null");
    }

    public ByteBuf getParameterValue(int index) {
        return this.parameterValues.get(index);
    }

    public CString getParameterValueAsText(int index) {
        if (!this.isParameterTextFormat(index)) {
            throw new IllegalArgumentException(String.format("parameter value %n is binary", index));
        }
        ByteBuf value = this.getParameterValue(index);
        return CString.valueOf((ByteBuf)value, (int)value.capacity());
    }

    public List<Short> getResultColumnFormats() {
        return this.resultColumnFormats;
    }

    public void setResultColumnFormats(List<Short> resultColumnFormats) {
        this.resultColumnFormats = Objects.requireNonNull(resultColumnFormats, "resultColumnFormats must not be null");
    }

    public short getResultColumnFormat(int index) {
        switch (this.resultColumnFormats.size()) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.resultColumnFormats.get(0);
            }
        }
        return this.resultColumnFormats.get(index);
    }

    public boolean isResultColumnTextFormat(int index) {
        return this.getResultColumnFormat(index) == 0;
    }

    public boolean isResultColumnBinaryFormat(int index) {
        return this.getResultColumnFormat(index) == 1;
    }

    @Override
    public byte getType() {
        return 66;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(StringUtil.simpleClassName((Object)this));
        builder.append(" [");
        builder.append("portal=").append((CharSequence)this.portal);
        builder.append(", preparedStatement=").append((CharSequence)this.preparedStatement);
        builder.append(", parameterFormats=").append(this.parameterFormats);
        builder.append(", parameterValues=").append(this.parameterValues);
        builder.append(", resultColumnFormats=").append(this.resultColumnFormats);
        builder.append("]");
        return builder.toString();
    }
}

