/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlAuthenticationResponse;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlMessageHandler;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.AuthenticationResponse;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.MessageTransferMode;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationResponseHandler
extends PgsqlMessageHandler<PgsqlAuthenticationResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationResponseHandler.class);

    public AuthenticationResponseHandler() {
        super(PgsqlAuthenticationResponse.class);
    }

    @Override
    protected PgsqlAuthenticationResponse process(ChannelHandlerContext ctx, PgsqlAuthenticationResponse msg) throws IOException {
        LOGGER.debug("Authentication Type : {}", (Object)msg.getAuthenticationType());
        PgsqlAuthenticationResponse newMsg = msg;
        AuthenticationResponse request = new AuthenticationResponse(msg.getAuthenticationType(), msg.getAuthenticationParameters());
        MessageTransferMode<AuthenticationResponse, Void> transferMode = this.getEventProcessor(ctx).processAuthenticationResponse(ctx, request);
        switch (transferMode.getTransferMode()) {
            case FORWARD: {
                AuthenticationResponse newRequest = transferMode.getNewContent();
                if (newRequest == request) break;
                newMsg = new PgsqlAuthenticationResponse(newRequest.getType(), newRequest.getParameters());
                LOGGER.trace("AuthenticationResponse modified: original was: {}", (Object)msg);
                LOGGER.trace("AuthenticationResponse modified: new is : {}", (Object)newMsg);
                break;
            }
            case FORGET: {
                newMsg = null;
                LOGGER.trace("AuthenticationResponse dropped");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for enum " + ((Object)((Object)transferMode.getTransferMode())).getClass().getSimpleName() + ": " + (Object)((Object)transferMode.getTransferMode()));
            }
        }
        return newMsg;
    }
}

