/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlAuthenticationRequest;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlMessageHandler;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlPasswordMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlStartupMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.MessageTransferMode;
import eu.clarussecure.proxy.protocol.plugins.tcp.handler.forwarder.DirectedMessage;
import eu.clarussecure.proxy.spi.CString;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationRequestHandler
extends PgsqlMessageHandler<PgsqlAuthenticationRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationRequestHandler.class);

    public AuthenticationRequestHandler() {
        super(PgsqlStartupMessage.class, PgsqlPasswordMessage.class);
    }

    @Override
    protected List<DirectedMessage<PgsqlAuthenticationRequest>> directedProcess(ChannelHandlerContext ctx, PgsqlAuthenticationRequest msg) throws IOException {
        switch (msg.getType()) {
            case 0: {
                return this.process(ctx, (PgsqlStartupMessage)msg, "startup", PgsqlStartupMessage::getParameters, parameters -> this.getEventProcessor(ctx).processUserIdentification(ctx, (Map<CString, CString>)parameters), newParameters -> new PgsqlStartupMessage(((PgsqlStartupMessage)msg).getProtocolVersion(), (Map<CString, CString>)newParameters));
            }
            case 112: {
                return this.process(ctx, (PgsqlPasswordMessage)msg, "password", PgsqlPasswordMessage::getPassword, password -> this.getEventProcessor(ctx).processUserAuthentication(ctx, (CString)password), PgsqlPasswordMessage::new);
            }
        }
        throw new IllegalArgumentException(String.format("msg type %c", Character.valueOf((char)msg.getType())));
    }

    private <M extends PgsqlAuthenticationRequest, C> List<DirectedMessage<PgsqlAuthenticationRequest>> process(ChannelHandlerContext ctx, M msg, String prefix, Function<M, C> supplier, CheckedFunction<C, MessageTransferMode<C, Void>> processor, Function<C, M> builder) throws IOException {
        List<Object> directedMsgs;
        LOGGER.debug("{}:", (Object)prefix);
        C content = supplier.apply(msg);
        MessageTransferMode<C, Void> transferMode = processor.apply(content);
        switch (transferMode.getTransferMode()) {
            case FORWARD: {
                if (transferMode.isDirected()) {
                    List<C> newContents = transferMode.getNewDirectedContents();
                    directedMsgs = new ArrayList<DirectedMessage<PgsqlAuthenticationRequest>>(newContents.size());
                    for (int i = 0; i < newContents.size(); ++i) {
                        C newContent = newContents.get(i);
                        Object newMsg = msg;
                        if (content != newContent) {
                            newMsg = (PgsqlAuthenticationRequest)builder.apply(newContent);
                            LOGGER.trace("{} modified: original was: {}", (Object)prefix, msg);
                            LOGGER.trace("{} modified: new is : {}", (Object)prefix, newMsg);
                        }
                        directedMsgs.add((DirectedMessage<PgsqlAuthenticationRequest>)new DirectedMessage(i, newMsg));
                    }
                    break;
                }
                C newContent = transferMode.getNewContent();
                Object newMsg = msg;
                if (content != newContent) {
                    newMsg = (PgsqlAuthenticationRequest)builder.apply(newContent);
                    LOGGER.trace("{} modified: original was: {}", (Object)prefix, msg);
                    LOGGER.trace("{} modified: new is : {}", (Object)prefix, newMsg);
                }
                DirectedMessage directedMsg = new DirectedMessage(-1, newMsg);
                directedMsgs = Collections.singletonList(directedMsg);
                break;
            }
            case ERROR: {
                this.sendErrorResponse(ctx, transferMode.getErrorDetails());
                directedMsgs = null;
                LOGGER.trace("{} dropped", (Object)prefix);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for enum " + ((Object)((Object)transferMode.getTransferMode())).getClass().getSimpleName() + ": " + (Object)((Object)transferMode.getTransferMode()));
            }
        }
        return directedMsgs;
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws IOException;
    }
}

