/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql;

import eu.clarussecure.proxy.protocol.plugins.pgsql.PgsqlConstants;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.AuthenticationRequestHandler;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.QueryRequestHandler;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.SessionInitializationRequestHandler;
import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.codec.PgsqlRawPartAccumulator;
import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.codec.PgsqlRawPartAggregator;
import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.codec.PgsqlRawPartCodec;
import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.forwarder.PgsqlRequestForwarder;
import eu.clarussecure.proxy.spi.protocol.Configuration;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;

public class FrontendSidePipelineInitializer
extends ChannelInitializer<Channel> {
    private static boolean MESSAGE_PROCESSING_ACTIVATED;
    private static boolean QUERY_PROCESSING_ACTIVATED;
    private EventExecutorGroup parserGroup = null;

    protected void initChannel(Channel ch) throws Exception {
        Configuration configuration = (Configuration)ch.attr(PgsqlConstants.CONFIGURATION_KEY).get();
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("PgsqlPartCodec", (ChannelHandler)new PgsqlRawPartCodec(true, configuration.getFramePartMaxLength()));
        if (MESSAGE_PROCESSING_ACTIVATED) {
            pipeline.addLast("PgsqlPartAggregator", (ChannelHandler)new PgsqlRawPartAggregator(-1, 0, -3, 80, 66, 68, 69, 67, 83, 72));
            pipeline.addLast("PgsqlPartAccumulator", (ChannelHandler)new PgsqlRawPartAccumulator(new int[]{81}));
        }
        if (this.parserGroup == null) {
            this.parserGroup = new DefaultEventExecutorGroup(configuration.getNbParserThreads());
        }
        pipeline.addLast(this.parserGroup, "SessionInitializationRequestHandler", (ChannelHandler)new SessionInitializationRequestHandler());
        if (MESSAGE_PROCESSING_ACTIVATED) {
            pipeline.addLast(this.parserGroup, "AuthenticationRequestHandler", (ChannelHandler)new AuthenticationRequestHandler());
            if (QUERY_PROCESSING_ACTIVATED) {
                pipeline.addLast(this.parserGroup, "QueryRequestHandler", (ChannelHandler)new QueryRequestHandler());
            }
        }
        pipeline.addLast(this.parserGroup, "PgsqlPartRequestForwarder", (ChannelHandler)new PgsqlRequestForwarder());
    }

    static {
        String messageProcessing = System.getProperty("pgsql.message.processing", "true");
        MESSAGE_PROCESSING_ACTIVATED = Boolean.TRUE.toString().equalsIgnoreCase(messageProcessing) || "1".equalsIgnoreCase(messageProcessing) || "yes".equalsIgnoreCase(messageProcessing) || "on".equalsIgnoreCase(messageProcessing);
        String queryProcessing = System.getProperty("pgsql.query.processing", "true");
        QUERY_PROCESSING_ACTIVATED = Boolean.TRUE.toString().equalsIgnoreCase(queryProcessing) || "1".equalsIgnoreCase(queryProcessing) || "yes".equalsIgnoreCase(queryProcessing) || "on".equalsIgnoreCase(queryProcessing);
    }
}

