/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.http.message.ssl;

import eu.clarussecure.proxy.protocol.plugins.http.HttpSession;
import eu.clarussecure.proxy.protocol.plugins.tcp.TCPConstants;
import eu.clarussecure.proxy.protocol.plugins.tcp.ssl.SSLSessionInitializer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpSessionInitializer.class);
    private volatile SSLSessionInitializer sslSessionInitializer = new SSLSessionInitializer();
    private boolean hasClientSideSSLHandler = false;
    private boolean hasServerSideSSLHandler = false;

    public void addSSLHandlerOnClientSide(ChannelHandlerContext ctx) throws IOException {
        Future handshakeFuture = this.sslSessionInitializer.addSSLHandlerOnClientSide(ctx, this.getHttpSession(ctx).getClientSideChannel().pipeline());
        handshakeFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Channel>>(){

            public void operationComplete(Future<? super Channel> future) throws Exception {
                LOGGER.trace("SSL handshake for client side completed");
            }
        });
        this.hasClientSideSSLHandler = true;
    }

    public void addSSLHandlerOnServerSide(ChannelHandlerContext ctx) throws SSLException {
        Future handshakeFuture = this.sslSessionInitializer.addSSLHandlerOnServerSide(ctx);
        handshakeFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Channel>>(){

            public void operationComplete(Future<? super Channel> future) throws Exception {
                LOGGER.trace("SSL handshake for server side completed");
            }
        });
        this.hasServerSideSSLHandler = true;
    }

    private HttpSession getHttpSession(ChannelHandlerContext ctx) {
        HttpSession httpSession = (HttpSession)((Object)ctx.channel().attr(TCPConstants.SESSION_KEY).get());
        return httpSession;
    }

    public boolean hasClientSideSSLHandler() {
        return this.hasClientSideSSLHandler;
    }

    public boolean hasServerSideSSLHandler() {
        return this.hasServerSideSSLHandler;
    }
}

