/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.http.message;

import eu.clarussecure.proxy.protocol.plugins.http.HttpConfiguration;
import eu.clarussecure.proxy.protocol.plugins.http.HttpSession;
import eu.clarussecure.proxy.protocol.plugins.http.message.HttpMessageHandler;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpMessageResponseHandler
extends HttpMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpMessageResponseHandler.class);

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        HttpConfiguration configuration = this.getConfiguration(ctx);
        HttpSession httpSession = this.getHttpSession(ctx);
        if (httpSession != null && configuration.isServerSSLMode() && !httpSession.getSessionInitializer().hasServerSideSSLHandler()) {
            this.getHttpSession(ctx).getSessionInitializer().addSSLHandlerOnServerSide(ctx);
            LOGGER.debug("Handler has been set on server side.");
        }
        super.channelActive(ctx);
        LOGGER.debug("Channel '" + ctx.name() + "' is active.");
    }
}

