/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.http.message;

import eu.clarussecure.proxy.protocol.plugins.http.HttpConfiguration;
import eu.clarussecure.proxy.protocol.plugins.http.HttpSession;
import eu.clarussecure.proxy.protocol.plugins.tcp.TCPConstants;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.HttpObject;
import io.netty.util.ReferenceCountUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpMessageHandler
extends MessageToMessageDecoder<HttpObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpMessageHandler.class);

    protected void decode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        LOGGER.debug("Decoding request message...");
        ReferenceCountUtil.retain((Object)msg);
        out.add(msg);
    }

    protected HttpSession getHttpSession(ChannelHandlerContext ctx) {
        HttpSession httpSession = (HttpSession)((Object)ctx.channel().attr(TCPConstants.SESSION_KEY).get());
        return httpSession;
    }

    protected HttpConfiguration getConfiguration(ChannelHandlerContext ctx) {
        HttpConfiguration configuration = (HttpConfiguration)((Object)ctx.channel().attr(TCPConstants.CONFIGURATION_KEY).get());
        return configuration;
    }
}

