/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.http.handler.codec;

import eu.clarussecure.proxy.protocol.plugins.http.HttpConfiguration;
import eu.clarussecure.proxy.protocol.plugins.http.HttpSession;
import eu.clarussecure.proxy.protocol.plugins.tcp.TCPConstants;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.ReferenceCountUtil;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHeaderCodec
extends MessageToMessageCodec<HttpRequest, HttpResponse> {
    private static final String SDCH_ENCODING = "sdch";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpHeaderCodec.class);
    private String requestHost;

    protected void encode(ChannelHandlerContext ctx, HttpResponse response, List<Object> out) throws Exception {
        ReferenceCountUtil.retain((Object)response);
        out.add(response);
    }

    protected void decode(ChannelHandlerContext ctx, HttpRequest request, List<Object> out) throws Exception {
        if (request.method().equals((Object)HttpMethod.CONNECT)) {
            DefaultHttpResponse response = new DefaultHttpResponse(request.protocolVersion(), HttpResponseStatus.OK);
            HttpSession httpSession = (HttpSession)((Object)ctx.channel().attr(TCPConstants.SESSION_KEY).get());
            httpSession.getClientSideChannel().writeAndFlush((Object)response);
        } else {
            ReferenceCountUtil.retain((Object)request);
            out.add(request);
        }
    }

    private void rewriteHostHeader(ChannelHandlerContext ctx, HttpRequest request) {
        HttpHeaders headers = request.headers();
        HttpConfiguration config = (HttpConfiguration)((Object)ctx.channel().attr(TCPConstants.CONFIGURATION_KEY).get());
        this.requestHost = headers.get((CharSequence)HttpHeaderNames.HOST);
        if (this.requestHost != null && !this.requestHost.isEmpty() && config.getServerEndpoint() != null) {
            headers.remove((CharSequence)HttpHeaderNames.HOST);
            headers.add((CharSequence)HttpHeaderNames.HOST, (Object)(config.getServerEndpoint().getAddress().getHostAddress() + ":" + config.getServerEndpoint().getPort()));
        }
    }

    private void removeSDCHEncoding(HttpRequest request) {
        HttpHeaders headers = request.headers();
        String ae = headers.get((CharSequence)HttpHeaderNames.ACCEPT_ENCODING);
        if (ae != null && !ae.isEmpty()) {
            List<String> encodings = Arrays.asList(ae.split(","));
            List filteredEncodings = encodings.stream().map(encoding -> encoding.replace(" ", "")).filter(encoding -> !SDCH_ENCODING.equalsIgnoreCase((String)encoding)).collect(Collectors.toList());
            headers.set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)String.join((CharSequence)",", filteredEncodings));
        }
    }

    private void rewriteLocationHeader(ChannelHandlerContext ctx, HttpResponse response) {
        HttpHeaders headers = response.headers();
        this.requestHost = headers.get((CharSequence)HttpHeaderNames.HOST);
        String originalUrlString = headers.getAsString((CharSequence)HttpHeaderNames.LOCATION);
        if (originalUrlString != null && !originalUrlString.isEmpty()) {
            try {
                HttpConfiguration config = (HttpConfiguration)((Object)ctx.channel().attr(TCPConstants.CONFIGURATION_KEY).get());
                String hostName = InetAddress.getLocalHost().getHostName();
                if (this.requestHost != null && !this.requestHost.isEmpty()) {
                    hostName = this.requestHost.split(":")[0];
                }
                URL originalURL = new URL(originalUrlString);
                headers.remove((CharSequence)HttpHeaderNames.LOCATION);
                headers.add((CharSequence)HttpHeaderNames.LOCATION, (Object)new URL(originalURL.getProtocol(), hostName, config.getListenPort(), originalURL.getFile()).toString());
            }
            catch (UnknownHostException e) {
                LOGGER.error("Can't retrieve localhost ip", (Throwable)e);
            }
            catch (MalformedURLException e) {
                LOGGER.error("Can't rewrite url of a Location header", (Throwable)e);
            }
        }
    }
}

