/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.http;

import eu.clarussecure.proxy.spi.CString;
import io.netty.buffer.ByteBuf;
import io.netty.util.ByteProcessor;
import java.nio.charset.Charset;

public class HttpUtilities {
    public static CString getCString(ByteBuf buffer) {
        int len;
        CString str = null;
        if (buffer != null && (len = buffer.bytesBefore((byte)0)) > -1) {
            str = CString.valueOf((ByteBuf)buffer.readSlice(len + 1), (int)len);
        }
        return str;
    }

    public static int computeLength(CharSequence str) {
        return (str != null ? str.length() : 0) + 1;
    }

    public static void putString(ByteBuf byteBuf, CharSequence str) {
        if (str != null) {
            byteBuf.writeCharSequence(str, Charset.forName("ISO-8859-1"));
        }
        byteBuf.writeByte(0);
    }

    public static String toString(ByteBuf byteBuf) {
        if (byteBuf == null) {
            return "";
        }
        final StringBuilder builder = new StringBuilder();
        byteBuf.forEachByte(new ByteProcessor(){

            public boolean process(byte value) throws Exception {
                builder.append(String.format("%02x", value & 0xFF));
                return true;
            }
        });
        return builder.toString();
    }
}

