/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.http;

import eu.clarussecure.proxy.protocol.plugins.http.handler.codec.HttpHeaderCodec;
import eu.clarussecure.proxy.protocol.plugins.http.handler.forwarder.HttpResponseForwarder;
import eu.clarussecure.proxy.protocol.plugins.http.message.SessionInitializationResponseHandler;
import eu.clarussecure.proxy.protocol.plugins.tcp.TCPConstants;
import eu.clarussecure.proxy.spi.protocol.Configuration;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;

public class HttpServerPipelineInitializer
extends ChannelInitializer<Channel> {
    protected void initChannel(Channel ch) throws Exception {
        Configuration configuration = (Configuration)ch.attr(TCPConstants.CONFIGURATION_KEY).get();
        ChannelPipeline pipeline = ch.pipeline();
        DefaultEventExecutorGroup parserGroup = new DefaultEventExecutorGroup(configuration.getNbParserThreads());
        pipeline.addLast((EventExecutorGroup)parserGroup, "SessionInitializationResponseHandler", (ChannelHandler)new SessionInitializationResponseHandler());
        pipeline.addLast((EventExecutorGroup)parserGroup, "HttpClientCodec", (ChannelHandler)new HttpClientCodec());
        pipeline.addLast((EventExecutorGroup)parserGroup, "HttpContentDecompressor", (ChannelHandler)new HttpContentDecompressor());
        pipeline.addLast((EventExecutorGroup)parserGroup, "HttpHeaderCodec", (ChannelHandler)new HttpHeaderCodec());
        pipeline.addLast((EventExecutorGroup)parserGroup, "HttpResponseForwarder", (ChannelHandler)new HttpResponseForwarder());
    }
}

