/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.http;

import eu.clarussecure.proxy.spi.protocol.Configuration;
import eu.clarussecure.proxy.spi.protocol.ProtocolCapabilities;

public class HttpConfiguration
extends Configuration {
    private static final String PROTOCOL_NAME = "HTTP/1.1";
    private static final int DEFAULT_PROTOCOL_PORT = 80;
    private static final int DEFAULT_CLIENT_SSL_PORT = 443;
    private static final int DEFAULT_SERVER_SSL_PORT = 443;
    private static final int DEFAULT_NB_OF_PARSER_THREADS = Runtime.getRuntime().availableProcessors();
    private boolean isClientSSLMode;
    private boolean isServerSSLMode;
    private int serverSSLPort;
    private int clientSSLPort;

    public HttpConfiguration(ProtocolCapabilities capabilities) {
        super(capabilities);
        this.nbParserThreads = DEFAULT_NB_OF_PARSER_THREADS;
    }

    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    public int getDefaultProtocolPort() {
        return 80;
    }

    public boolean isClientSSLMode() {
        return this.isClientSSLMode || this.getListenPort() == this.getClientSSLPort();
    }

    public boolean isServerSSLMode() {
        return this.isServerSSLMode || this.getServerEndpoint().getPort() == this.getServerSSLPort();
    }

    public void setSSLClient(boolean isSSLClient) {
        this.isClientSSLMode = isSSLClient;
    }

    public void setSSLServer(boolean isSSLServer) {
        this.isServerSSLMode = isSSLServer;
    }

    public void setServerSSLPort(Integer serverSSLPort) {
        this.serverSSLPort = serverSSLPort;
    }

    public void setClientSSLPort(Integer clientSSLPort) {
        this.clientSSLPort = clientSSLPort;
    }

    public int getClientSSLPort() {
        return this.clientSSLPort != 0 ? this.clientSSLPort : 443;
    }

    public int getServerSSLPort() {
        return this.serverSSLPort != 0 ? this.serverSSLPort : 443;
    }
}

