/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.http;

import eu.clarussecure.proxy.protocol.plugins.http.handler.codec.HttpHeaderCodec;
import eu.clarussecure.proxy.protocol.plugins.http.handler.forwarder.HttpRequestForwarder;
import eu.clarussecure.proxy.protocol.plugins.http.message.SessionInitializationRequestHandler;
import eu.clarussecure.proxy.protocol.plugins.tcp.TCPConstants;
import eu.clarussecure.proxy.spi.protocol.Configuration;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;

public class HttpClientPipelineInitializer
extends ChannelInitializer<Channel> {
    protected void initChannel(Channel ch) throws Exception {
        Configuration configuration = (Configuration)ch.attr(TCPConstants.CONFIGURATION_KEY).get();
        ChannelPipeline pipeline = ch.pipeline();
        DefaultEventExecutorGroup parserGroup = new DefaultEventExecutorGroup(configuration.getNbParserThreads());
        pipeline.addLast((EventExecutorGroup)parserGroup, "SessionInitializationRequestHandler", (ChannelHandler)new SessionInitializationRequestHandler());
        pipeline.addLast((EventExecutorGroup)parserGroup, "HttpServerCodec", (ChannelHandler)new HttpServerCodec());
        pipeline.addLast((EventExecutorGroup)parserGroup, "HttpHeaderCodec", (ChannelHandler)new HttpHeaderCodec());
        pipeline.addLast((EventExecutorGroup)parserGroup, "HttpRequestForwarder", (ChannelHandler)new HttpRequestForwarder());
    }
}

