/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protection.modules.anonymization;

import eu.clarussecure.proxy.spi.Capabilities;
import eu.clarussecure.proxy.spi.Mode;
import eu.clarussecure.proxy.spi.Operation;
import eu.clarussecure.proxy.spi.protection.ProtectionModuleCapabilities;
import eu.clarussecure.proxy.spi.security.policy.SecurityPolicy;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnonymizationCapabilities
implements ProtectionModuleCapabilities {
    private final Map<Operation, Set<Mode>> datasetCRUDOperations = Capabilities.toMap((Enum[][])new Enum[][]{{Operation.CREATE, Mode.AS_IT_IS, Mode.BUFFERING, Mode.STREAMING}, {Operation.READ, Mode.AS_IT_IS}, {Operation.UPDATE}, {Operation.DELETE, Mode.AS_IT_IS}});
    private final Map<Operation, Set<Mode>> recordCRUDOperations = Capabilities.toMap((Enum[][])new Enum[][]{{Operation.CREATE}, {Operation.READ, Mode.AS_IT_IS}, {Operation.UPDATE}, {Operation.DELETE}});

    public Set<Operation> getSupportedCRUDOperations(boolean wholeDataset) {
        return wholeDataset ? this.datasetCRUDOperations.keySet() : this.recordCRUDOperations.keySet();
    }

    public Set<Mode> getSupportedProcessingModes(boolean wholeDataset, Operation operation) {
        return wholeDataset ? this.datasetCRUDOperations.get(operation) : this.recordCRUDOperations.get(operation);
    }

    public Mode getPreferredProcessingMode(boolean wholedataset, Operation operation, SecurityPolicy securityPolicy) {
        Node rootNode;
        Node protectionNode;
        Node attributeTypesNode;
        Set<Mode> modes = this.getSupportedProcessingModes(wholedataset, operation);
        if (modes.size() <= 1) {
            return modes.isEmpty() ? null : modes.iterator().next();
        }
        Mode preferredMode = Mode.AS_IT_IS;
        if (wholedataset && operation == Operation.CREATE && (attributeTypesNode = securityPolicy.findSubNode("attribute_types", protectionNode = securityPolicy.findSubNode("protection", rootNode = securityPolicy.getDocument().getFirstChild()))).hasChildNodes()) {
            preferredMode = Mode.STREAMING;
            NodeList subnodes = attributeTypesNode.getChildNodes();
            for (int i = 0; i < subnodes.getLength(); ++i) {
                Node protectionAttr;
                Node subnode = subnodes.item(i);
                if (subnode.getNodeType() != 1 || !subnode.getNodeName().equals("attribute_type") || (protectionAttr = subnode.getAttributes().getNamedItem("protection")) == null) continue;
                String protection = protectionAttr.getNodeValue();
                if ("coarsening".equals(protection)) {
                    String coarseningType;
                    Node coarseningTypeAttr = subnode.getAttributes().getNamedItem("coarsening_type");
                    if (coarseningTypeAttr == null || !"microaggregation".equals(coarseningType = coarseningTypeAttr.getNodeValue())) continue;
                    preferredMode = Mode.BUFFERING;
                    break;
                }
                if (!"k-anonymity".equals(protection) && !"t-closeness".equals(protection)) continue;
                preferredMode = Mode.BUFFERING;
                break;
            }
        }
        return preferredMode;
    }
}

