/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.spi.security.policy;

import eu.clarussecure.proxy.spi.security.policy.MyErrorHandler;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SecurityPolicy {
    public static final String DATA_ELT = "data";
    public static final String ATTRIBUTE_ELT = "attribute";
    public static final String NAME_ATTR = "name";
    public static final String PROTOCOL_ELT = "protocol";
    public static final String PARAMETER_ELT = "parameter";
    public static final String PARAM_ATTR = "param";
    public static final String VALUE_ATTR = "value";
    public static final String PLUGIN_ATTR = "plugin";
    public static final String PORT_ATTR = "listen";
    public static final String PROTECTION_ELT = "protection";
    public static final String MODULE_ATTR = "module";
    private final Document document;

    private SecurityPolicy(Document document) {
        this.document = document;
    }

    public static SecurityPolicy load(File securityPolicyFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        OutputStreamWriter errorWriter = new OutputStreamWriter(System.err);
        db.setErrorHandler(new MyErrorHandler(new PrintWriter((Writer)errorWriter, true)));
        Document doc = db.parse(securityPolicyFile);
        return new SecurityPolicy(doc);
    }

    public Document getDocument() {
        return this.document;
    }

    public String[] getDataIds() {
        Node root = this.document.getFirstChild();
        Node data = this.findSubNode(DATA_ELT, root);
        List<Node> attributes = this.findSubNodes(ATTRIBUTE_ELT, data);
        if (attributes != null) {
            ArrayList<String> names = new ArrayList<String>(attributes.size());
            for (Node attribute : attributes) {
                Node name;
                if (attribute == null || (name = attribute.getAttributes().getNamedItem(NAME_ATTR)) == null) continue;
                names.add(name.getNodeValue());
            }
            return names.toArray(new String[names.size()]);
        }
        return null;
    }

    public void setDataIds(String[] names) {
        Node root = this.document.getFirstChild();
        Node data = this.findSubNode(DATA_ELT, root);
        List<Node> attributes = this.findSubNodes(ATTRIBUTE_ELT, data);
        if (attributes != null) {
            for (int i = 0; i < attributes.size(); ++i) {
                Node name;
                Node attribute = attributes.get(i);
                if (attribute == null || (name = attribute.getAttributes().getNamedItem(NAME_ATTR)) == null) continue;
                name.setNodeValue(names[i]);
            }
        }
    }

    public Map<String, String> getProtocolParameters() {
        List<Node> parameters;
        Node root = this.document.getFirstChild();
        Node protocol = this.findSubNode(PROTOCOL_ELT, root);
        if (protocol != null && (parameters = this.findSubNodes(PARAMETER_ELT, protocol)) != null) {
            HashMap<String, String> params = new HashMap<String, String>(parameters.size());
            for (Node parameter : parameters) {
                if (parameter == null) continue;
                Node param = parameter.getAttributes().getNamedItem(PARAM_ATTR);
                Node value = parameter.getAttributes().getNamedItem(VALUE_ATTR);
                if (param == null || value == null) continue;
                params.put(param.getNodeValue(), value.getNodeValue());
            }
            return params;
        }
        return null;
    }

    public String getProtocolPluginName() {
        Node plugin;
        Node root = this.document.getFirstChild();
        Node protocol = this.findSubNode(PROTOCOL_ELT, root);
        String pluginName = null;
        if (protocol != null && (plugin = protocol.getAttributes().getNamedItem(PLUGIN_ATTR)) != null) {
            pluginName = plugin.getNodeValue();
        }
        return pluginName;
    }

    public Integer getProtocolListenPort() {
        String value;
        Node port;
        Node root = this.document.getFirstChild();
        Node protocol = this.findSubNode(PROTOCOL_ELT, root);
        Integer listenPort = null;
        if (protocol != null && (port = protocol.getAttributes().getNamedItem(PORT_ATTR)) != null && (value = port.getNodeValue()) != null) {
            listenPort = Integer.valueOf(value);
        }
        return listenPort;
    }

    public String getProtectionModuleName() {
        Node module;
        Node root = this.document.getFirstChild();
        Node protection = this.findSubNode(PROTECTION_ELT, root);
        String protectionModuleName = null;
        if (protection != null && (module = protection.getAttributes().getNamedItem(MODULE_ATTR)) != null) {
            protectionModuleName = module.getNodeValue();
        }
        return protectionModuleName;
    }

    public Node findSubNode(String name, Node node) {
        if (node.getNodeType() != 1) {
            System.err.println("Error: Search node not of element type");
            System.exit(22);
        }
        if (!node.hasChildNodes()) {
            return null;
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node subnode = list.item(i);
            if (subnode.getNodeType() != 1 || !subnode.getNodeName().equals(name)) continue;
            return subnode;
        }
        return null;
    }

    public List<Node> findSubNodes(String name, Node node) {
        if (node.getNodeType() != 1) {
            System.err.println("Error: Search node not of element type");
            System.exit(22);
        }
        if (!node.hasChildNodes()) {
            return null;
        }
        NodeList list = node.getChildNodes();
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < list.getLength(); ++i) {
            Node subnode = list.item(i);
            if (subnode.getNodeType() != 1 || !subnode.getNodeName().equals(name)) continue;
            nodes.add(subnode);
        }
        return nodes;
    }
}

