/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.spi.protocol;

import eu.clarussecure.proxy.spi.protocol.Protocol;
import eu.clarussecure.proxy.spi.protocol.ProtocolServer;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public abstract class ProtocolExecutor
implements Protocol,
Closeable {
    private Callable<Void> server;
    private Future<Void> future;

    @Override
    public void start() {
        this.server = this.buildServer();
        try {
            this.future = Executors.newSingleThreadExecutor().submit(this.server);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract Callable<Void> buildServer();

    @Override
    public void waitForServerIsReady() throws InterruptedException {
        if (!(this.server instanceof ProtocolServer)) {
            throw new UnsupportedOperationException("the underlying server does not implement the ProtocolServer interface");
        }
        ((ProtocolServer)this.server).waitForServerIsReady();
    }

    @Override
    public void sync() throws InterruptedException, ExecutionException {
        try {
            this.future.get();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    @Override
    public void stop() {
        this.future.cancel(true);
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }
}

