/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.spi.protocol;

import eu.clarussecure.proxy.spi.Mode;
import eu.clarussecure.proxy.spi.Operation;
import eu.clarussecure.proxy.spi.protocol.Configurable;
import eu.clarussecure.proxy.spi.protocol.ProtocolCapabilities;
import eu.clarussecure.proxy.spi.protocol.ProtocolService;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Configuration
implements Configurable {
    public static final int DEFAULT_NB_OF_LISTEN_THREADS = 1;
    public static final int DEFAULT_NB_OF_SESSION_THREADS = Runtime.getRuntime().availableProcessors();
    public static final int DEFAULT_NB_OF_PARSER_THREADS = 0;
    public static final int DEFAULT_FRAME_PART_MAX_LENGTH = Integer.MAX_VALUE;
    protected final ProtocolCapabilities capabilities;
    protected int listenPort;
    protected List<InetSocketAddress> serverEndpoints;
    protected Map<String, String> parameters;
    protected int nbListenThreads = 1;
    protected int nbSessionThreads = DEFAULT_NB_OF_SESSION_THREADS;
    protected int nbParserThreads = 0;
    protected int framePartMaxLength = Integer.MAX_VALUE;
    protected Map<Operation, Mode> datasetProcessingModes = new HashMap<Operation, Mode>();
    protected Map<Operation, Mode> recordProcessingModes = new HashMap<Operation, Mode>();
    protected Set<String> commands = null;
    protected ProtocolService protocolService = null;

    public Configuration(ProtocolCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public int getListenPort() {
        return this.listenPort != 0 ? this.listenPort : this.getDefaultProtocolPort();
    }

    @Override
    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    @Override
    public InetSocketAddress getServerEndpoint(int index) {
        if (this.serverEndpoints != null) {
            if (index >= this.serverEndpoints.size()) {
                throw new IllegalArgumentException(String.format("index (%d) >= number of endpoints (%d)", index, this.serverEndpoints.size()));
            }
            return this.serverEndpoints.get(index);
        }
        return null;
    }

    @Override
    public List<InetSocketAddress> getServerEndpoints() {
        return this.serverEndpoints;
    }

    @Override
    public void setServerAddress(InetAddress serverAddress) {
        this.serverEndpoints = Collections.singletonList(new InetSocketAddress(serverAddress, this.getDefaultProtocolPort()));
    }

    @Override
    public void setServerEndpoint(InetSocketAddress serverEndpoint) {
        this.serverEndpoints = Collections.singletonList(serverEndpoint);
    }

    @Override
    public void setServerAddresses(List<InetAddress> serverAddresses) {
        this.serverEndpoints = serverAddresses.stream().map(serverAddress -> new InetSocketAddress((InetAddress)serverAddress, this.getDefaultProtocolPort())).collect(Collectors.toList());
    }

    @Override
    public void setServerAddresses(InetAddress ... serverAddresses) {
        this.serverEndpoints = Stream.of(serverAddresses).map(serverAddress -> new InetSocketAddress((InetAddress)serverAddress, this.getDefaultProtocolPort())).collect(Collectors.toList());
    }

    @Override
    public void setServerEndpoints(List<InetSocketAddress> serverEndpoints) {
        this.serverEndpoints = serverEndpoints;
    }

    @Override
    public void setServerEndpoints(InetSocketAddress ... serverEndpoints) {
        this.serverEndpoints = Stream.of(serverEndpoints).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Override
    public int getNbListenThreads() {
        return this.nbListenThreads;
    }

    @Override
    public void setNbListenThreads(int nThreads) {
        if (nThreads <= 0) {
            throw new IllegalArgumentException("nThreads must be positive");
        }
        this.nbListenThreads = nThreads;
    }

    @Override
    public int getNbSessionThreads() {
        return this.nbSessionThreads;
    }

    @Override
    public void setNbSessionThreads(int nThreads) {
        if (nThreads <= 0) {
            throw new IllegalArgumentException("nThreads must be positive");
        }
        this.nbSessionThreads = nThreads;
    }

    @Override
    public int getNbParserThreads() {
        return this.nbParserThreads;
    }

    @Override
    public void setNbParserThreads(int nThreads) {
        if (nThreads < 0) {
            throw new IllegalArgumentException("nThreads must be positive or 0");
        }
        this.nbParserThreads = nThreads;
    }

    @Override
    public int getFramePartMaxLength() {
        return this.framePartMaxLength;
    }

    @Override
    public void setFramePartMaxLength(int maxlen) {
        this.framePartMaxLength = maxlen;
    }

    @Override
    public void registerDataTypes() {
    }

    @Override
    public Mode getProcessingMode(boolean wholeDataset, Operation operation) {
        if (!this.capabilities.getSupportedCRUDOperations(wholeDataset).contains((Object)operation)) {
            throw new IllegalArgumentException(String.format("Operation '%s' is not supported on %s", new Object[]{operation, wholeDataset ? "dataset" : "record"}));
        }
        return wholeDataset ? this.datasetProcessingModes.get((Object)operation) : this.recordProcessingModes.get((Object)operation);
    }

    @Override
    public void setProcessingMode(boolean wholeDataset, Operation operation, Mode mode) {
        if (!this.capabilities.getSupportedCRUDOperations(wholeDataset).contains((Object)operation)) {
            throw new IllegalArgumentException(String.format("Operation '%s' is not supported on %s", new Object[]{operation, wholeDataset ? "dataset" : "record"}));
        }
        if (mode != null && !this.capabilities.getSupportedProcessingModes(wholeDataset, operation).contains((Object)mode)) {
            throw new IllegalArgumentException(String.format("Processing mode '%s' is not supported for operation '%s' on %s", new Object[]{mode, operation, wholeDataset ? "dataset" : "record"}));
        }
        if (wholeDataset) {
            this.datasetProcessingModes.put(operation, mode);
        } else {
            this.recordProcessingModes.put(operation, mode);
        }
    }

    @Override
    public Set<String> getComputationCommands() {
        return this.commands;
    }

    @Override
    public void setComputationCommands(Set<String> commands) {
        if (!this.capabilities.getSupportedCRUDOperations(true).contains((Object)Operation.READ) && !this.capabilities.getSupportedCRUDOperations(false).contains((Object)Operation.READ)) {
            throw new IllegalArgumentException("Operation 'READ' is not supported on dataset and on record");
        }
        if (!this.capabilities.getSupportedProcessingModes(true, Operation.READ).contains((Object)Mode.ORCHESTRATION) && !this.capabilities.getSupportedProcessingModes(false, Operation.READ).contains((Object)Mode.ORCHESTRATION)) {
            throw new IllegalArgumentException("Processing mode 'ORCHESTRATION' is not supported for operation 'READ' on dataset and on record");
        }
        this.commands = commands;
    }

    @Override
    public ProtocolService getProtocolService() {
        return this.protocolService;
    }

    @Override
    public void register(ProtocolService protocolService) {
        this.protocolService = protocolService;
    }
}

