/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.spi.buffer;

import eu.clarussecure.proxy.spi.buffer.ConcurrentByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

public class SynchonizedByteBuf
extends ByteBuf
implements ConcurrentByteBuf {
    private final ByteBuf buf;

    public static SynchonizedByteBuf wrap(ByteBuf buf) {
        return new SynchonizedByteBuf(buf);
    }

    public SynchonizedByteBuf(ByteBuf buf) {
        if (buf == null) {
            throw new NullPointerException("buf");
        }
        this.buf = buf;
    }

    public final synchronized boolean hasMemoryAddress() {
        return this.buf.hasMemoryAddress();
    }

    public final synchronized long memoryAddress() {
        return this.buf.memoryAddress();
    }

    public final synchronized int capacity() {
        return this.buf.capacity();
    }

    public synchronized ByteBuf capacity(int newCapacity) {
        this.buf.capacity(newCapacity);
        return this;
    }

    public final synchronized int maxCapacity() {
        return this.buf.maxCapacity();
    }

    public final synchronized ByteBufAllocator alloc() {
        return this.buf.alloc();
    }

    public final synchronized ByteOrder order() {
        return this.buf.order();
    }

    public synchronized ByteBuf order(ByteOrder endianness) {
        return SynchonizedByteBuf.wrap(this.buf.order(endianness));
    }

    public final synchronized ByteBuf unwrap() {
        return this.buf;
    }

    public synchronized ByteBuf asReadOnly() {
        return SynchonizedByteBuf.wrap(this.buf.asReadOnly());
    }

    public synchronized boolean isReadOnly() {
        return this.buf.isReadOnly();
    }

    public final synchronized boolean isDirect() {
        return this.buf.isDirect();
    }

    public final synchronized int readerIndex() {
        return this.buf.readerIndex();
    }

    public final synchronized ByteBuf readerIndex(int readerIndex) {
        this.buf.readerIndex(readerIndex);
        return this;
    }

    public final synchronized int writerIndex() {
        return this.buf.writerIndex();
    }

    public final synchronized ByteBuf writerIndex(int writerIndex) {
        this.buf.writerIndex(writerIndex);
        return this;
    }

    public synchronized ByteBuf setIndex(int readerIndex, int writerIndex) {
        this.buf.setIndex(readerIndex, writerIndex);
        return this;
    }

    public final synchronized int readableBytes() {
        return this.buf.readableBytes();
    }

    public final synchronized int writableBytes() {
        return this.buf.writableBytes();
    }

    public final synchronized int maxWritableBytes() {
        return this.buf.maxWritableBytes();
    }

    public final synchronized boolean isReadable() {
        return this.buf.isReadable();
    }

    public final synchronized boolean isWritable() {
        return this.buf.isWritable();
    }

    public final synchronized ByteBuf clear() {
        this.buf.clear();
        return this;
    }

    public final synchronized ByteBuf markReaderIndex() {
        this.buf.markReaderIndex();
        return this;
    }

    public final synchronized ByteBuf resetReaderIndex() {
        this.buf.resetReaderIndex();
        return this;
    }

    public final synchronized ByteBuf markWriterIndex() {
        this.buf.markWriterIndex();
        return this;
    }

    public final synchronized ByteBuf resetWriterIndex() {
        this.buf.resetWriterIndex();
        return this;
    }

    public synchronized ByteBuf discardReadBytes() {
        this.buf.discardReadBytes();
        return this;
    }

    public synchronized ByteBuf discardSomeReadBytes() {
        this.buf.discardSomeReadBytes();
        return this;
    }

    public synchronized ByteBuf ensureWritable(int minWritableBytes) {
        this.buf.ensureWritable(minWritableBytes);
        return this;
    }

    public synchronized int ensureWritable(int minWritableBytes, boolean force) {
        return this.buf.ensureWritable(minWritableBytes, force);
    }

    public synchronized boolean getBoolean(int index) {
        return this.buf.getBoolean(index);
    }

    public synchronized byte getByte(int index) {
        return this.buf.getByte(index);
    }

    public synchronized short getUnsignedByte(int index) {
        return this.buf.getUnsignedByte(index);
    }

    public synchronized short getShort(int index) {
        return this.buf.getShort(index);
    }

    public synchronized short getShortLE(int index) {
        return this.buf.getShortLE(index);
    }

    public synchronized int getUnsignedShort(int index) {
        return this.buf.getUnsignedShort(index);
    }

    public synchronized int getUnsignedShortLE(int index) {
        return this.buf.getUnsignedShortLE(index);
    }

    public synchronized int getMedium(int index) {
        return this.buf.getMedium(index);
    }

    public synchronized int getMediumLE(int index) {
        return this.buf.getMediumLE(index);
    }

    public synchronized int getUnsignedMedium(int index) {
        return this.buf.getUnsignedMedium(index);
    }

    public synchronized int getUnsignedMediumLE(int index) {
        return this.buf.getUnsignedMediumLE(index);
    }

    public synchronized int getInt(int index) {
        return this.buf.getInt(index);
    }

    public synchronized int getIntLE(int index) {
        return this.buf.getIntLE(index);
    }

    public synchronized long getUnsignedInt(int index) {
        return this.buf.getUnsignedInt(index);
    }

    public synchronized long getUnsignedIntLE(int index) {
        return this.buf.getUnsignedIntLE(index);
    }

    public synchronized long getLong(int index) {
        return this.buf.getLong(index);
    }

    public synchronized long getLongLE(int index) {
        return this.buf.getLongLE(index);
    }

    public synchronized char getChar(int index) {
        return this.buf.getChar(index);
    }

    public synchronized float getFloat(int index) {
        return this.buf.getFloat(index);
    }

    public synchronized double getDouble(int index) {
        return this.buf.getDouble(index);
    }

    public synchronized ByteBuf getBytes(int index, ByteBuf dst) {
        this.buf.getBytes(index, dst);
        return this;
    }

    public synchronized ByteBuf getBytes(int index, ByteBuf dst, int length) {
        this.buf.getBytes(index, dst, length);
        return this;
    }

    public synchronized ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.buf.getBytes(index, dst, dstIndex, length);
        return this;
    }

    public synchronized ByteBuf getBytes(int index, byte[] dst) {
        this.buf.getBytes(index, dst);
        return this;
    }

    public synchronized ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.buf.getBytes(index, dst, dstIndex, length);
        return this;
    }

    public synchronized ByteBuf getBytes(int index, ByteBuffer dst) {
        this.buf.getBytes(index, dst);
        return this;
    }

    public synchronized ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.buf.getBytes(index, out, length);
        return this;
    }

    public synchronized int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        return this.buf.getBytes(index, out, length);
    }

    public synchronized int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        return this.buf.getBytes(index, out, position, length);
    }

    public synchronized CharSequence getCharSequence(int index, int length, Charset charset) {
        return this.buf.getCharSequence(index, length, charset);
    }

    public synchronized ByteBuf setBoolean(int index, boolean value) {
        this.buf.setBoolean(index, value);
        return this;
    }

    public synchronized ByteBuf setByte(int index, int value) {
        this.buf.setByte(index, value);
        return this;
    }

    public synchronized ByteBuf setShort(int index, int value) {
        this.buf.setShort(index, value);
        return this;
    }

    public synchronized ByteBuf setShortLE(int index, int value) {
        this.buf.setShortLE(index, value);
        return this;
    }

    public synchronized ByteBuf setMedium(int index, int value) {
        this.buf.setMedium(index, value);
        return this;
    }

    public synchronized ByteBuf setMediumLE(int index, int value) {
        this.buf.setMediumLE(index, value);
        return this;
    }

    public synchronized ByteBuf setInt(int index, int value) {
        this.buf.setInt(index, value);
        return this;
    }

    public synchronized ByteBuf setIntLE(int index, int value) {
        this.buf.setIntLE(index, value);
        return this;
    }

    public synchronized ByteBuf setLong(int index, long value) {
        this.buf.setLong(index, value);
        return this;
    }

    public synchronized ByteBuf setLongLE(int index, long value) {
        this.buf.setLongLE(index, value);
        return this;
    }

    public synchronized ByteBuf setChar(int index, int value) {
        this.buf.setChar(index, value);
        return this;
    }

    public synchronized ByteBuf setFloat(int index, float value) {
        this.buf.setFloat(index, value);
        return this;
    }

    public synchronized ByteBuf setDouble(int index, double value) {
        this.buf.setDouble(index, value);
        return this;
    }

    public synchronized ByteBuf setBytes(int index, ByteBuf src) {
        this.buf.setBytes(index, src);
        return this;
    }

    public synchronized ByteBuf setBytes(int index, ByteBuf src, int length) {
        this.buf.setBytes(index, src, length);
        return this;
    }

    public synchronized ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.buf.setBytes(index, src, srcIndex, length);
        return this;
    }

    public synchronized ByteBuf setBytes(int index, byte[] src) {
        this.buf.setBytes(index, src);
        return this;
    }

    public synchronized ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.buf.setBytes(index, src, srcIndex, length);
        return this;
    }

    public synchronized ByteBuf setBytes(int index, ByteBuffer src) {
        this.buf.setBytes(index, src);
        return this;
    }

    public synchronized int setBytes(int index, InputStream in, int length) throws IOException {
        return this.buf.setBytes(index, in, length);
    }

    public synchronized int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        return this.buf.setBytes(index, in, length);
    }

    public synchronized int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        return this.buf.setBytes(index, in, position, length);
    }

    public synchronized ByteBuf setZero(int index, int length) {
        this.buf.setZero(index, length);
        return this;
    }

    public synchronized int setCharSequence(int index, CharSequence sequence, Charset charset) {
        return this.buf.setCharSequence(index, sequence, charset);
    }

    public synchronized boolean readBoolean() {
        return this.buf.readBoolean();
    }

    public synchronized byte readByte() {
        return this.buf.readByte();
    }

    public synchronized short readUnsignedByte() {
        return this.buf.readUnsignedByte();
    }

    public synchronized short readShort() {
        return this.buf.readShort();
    }

    public synchronized short readShortLE() {
        return this.buf.readShortLE();
    }

    public synchronized int readUnsignedShort() {
        return this.buf.readUnsignedShort();
    }

    public synchronized int readUnsignedShortLE() {
        return this.buf.readUnsignedShortLE();
    }

    public synchronized int readMedium() {
        return this.buf.readMedium();
    }

    public synchronized int readMediumLE() {
        return this.buf.readMediumLE();
    }

    public synchronized int readUnsignedMedium() {
        return this.buf.readUnsignedMedium();
    }

    public synchronized int readUnsignedMediumLE() {
        return this.buf.readUnsignedMediumLE();
    }

    public synchronized int readInt() {
        return this.buf.readInt();
    }

    public synchronized int readIntLE() {
        return this.buf.readIntLE();
    }

    public synchronized long readUnsignedInt() {
        return this.buf.readUnsignedInt();
    }

    public synchronized long readUnsignedIntLE() {
        return this.buf.readUnsignedIntLE();
    }

    public synchronized long readLong() {
        return this.buf.readLong();
    }

    public synchronized long readLongLE() {
        return this.buf.readLongLE();
    }

    public synchronized char readChar() {
        return this.buf.readChar();
    }

    public synchronized float readFloat() {
        return this.buf.readFloat();
    }

    public synchronized double readDouble() {
        return this.buf.readDouble();
    }

    public synchronized ByteBuf readBytes(int length) {
        return SynchonizedByteBuf.wrap(this.buf.readBytes(length));
    }

    public synchronized ByteBuf readSlice(int length) {
        return SynchonizedByteBuf.wrap(this.buf.readSlice(length));
    }

    public synchronized ByteBuf readRetainedSlice(int length) {
        return SynchonizedByteBuf.wrap(this.buf.readRetainedSlice(length));
    }

    public synchronized ByteBuf readBytes(ByteBuf dst) {
        this.buf.readBytes(dst);
        return this;
    }

    public synchronized ByteBuf readBytes(ByteBuf dst, int length) {
        this.buf.readBytes(dst, length);
        return this;
    }

    public synchronized ByteBuf readBytes(ByteBuf dst, int dstIndex, int length) {
        this.buf.readBytes(dst, dstIndex, length);
        return this;
    }

    public synchronized ByteBuf readBytes(byte[] dst) {
        this.buf.readBytes(dst);
        return this;
    }

    public synchronized ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        this.buf.readBytes(dst, dstIndex, length);
        return this;
    }

    public synchronized ByteBuf readBytes(ByteBuffer dst) {
        this.buf.readBytes(dst);
        return this;
    }

    public synchronized ByteBuf readBytes(OutputStream out, int length) throws IOException {
        this.buf.readBytes(out, length);
        return this;
    }

    public synchronized int readBytes(GatheringByteChannel out, int length) throws IOException {
        return this.buf.readBytes(out, length);
    }

    public synchronized int readBytes(FileChannel out, long position, int length) throws IOException {
        return this.buf.readBytes(out, position, length);
    }

    public synchronized CharSequence readCharSequence(int length, Charset charset) {
        return this.buf.readCharSequence(length, charset);
    }

    public synchronized ByteBuf skipBytes(int length) {
        this.buf.skipBytes(length);
        return this;
    }

    public synchronized ByteBuf writeBoolean(boolean value) {
        this.buf.writeBoolean(value);
        return this;
    }

    public synchronized ByteBuf writeByte(int value) {
        this.buf.writeByte(value);
        return this;
    }

    public synchronized ByteBuf writeShort(int value) {
        this.buf.writeShort(value);
        return this;
    }

    public synchronized ByteBuf writeShortLE(int value) {
        this.buf.writeShortLE(value);
        return this;
    }

    public synchronized ByteBuf writeMedium(int value) {
        this.buf.writeMedium(value);
        return this;
    }

    public synchronized ByteBuf writeMediumLE(int value) {
        this.buf.writeMediumLE(value);
        return this;
    }

    public synchronized ByteBuf writeInt(int value) {
        this.buf.writeInt(value);
        return this;
    }

    public synchronized ByteBuf writeIntLE(int value) {
        this.buf.writeIntLE(value);
        return this;
    }

    public synchronized ByteBuf writeLong(long value) {
        this.buf.writeLong(value);
        return this;
    }

    public synchronized ByteBuf writeLongLE(long value) {
        this.buf.writeLongLE(value);
        return this;
    }

    public synchronized ByteBuf writeChar(int value) {
        this.buf.writeChar(value);
        return this;
    }

    public synchronized ByteBuf writeFloat(float value) {
        this.buf.writeFloat(value);
        return this;
    }

    public synchronized ByteBuf writeDouble(double value) {
        this.buf.writeDouble(value);
        return this;
    }

    public synchronized ByteBuf writeBytes(ByteBuf src) {
        this.buf.writeBytes(src);
        return this;
    }

    public synchronized ByteBuf writeBytes(ByteBuf src, int length) {
        this.buf.writeBytes(src, length);
        return this;
    }

    public synchronized ByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
        this.buf.writeBytes(src, srcIndex, length);
        return this;
    }

    public synchronized ByteBuf writeBytes(byte[] src) {
        this.buf.writeBytes(src);
        return this;
    }

    public synchronized ByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        this.buf.writeBytes(src, srcIndex, length);
        return this;
    }

    public synchronized ByteBuf writeBytes(ByteBuffer src) {
        this.buf.writeBytes(src);
        return this;
    }

    public synchronized int writeBytes(InputStream in, int length) throws IOException {
        return this.buf.writeBytes(in, length);
    }

    public synchronized int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        return this.buf.writeBytes(in, length);
    }

    public synchronized int writeBytes(FileChannel in, long position, int length) throws IOException {
        return this.buf.writeBytes(in, position, length);
    }

    public synchronized ByteBuf writeZero(int length) {
        this.buf.writeZero(length);
        return this;
    }

    public synchronized int writeCharSequence(CharSequence sequence, Charset charset) {
        return this.buf.writeCharSequence(sequence, charset);
    }

    public synchronized int indexOf(int fromIndex, int toIndex, byte value) {
        return this.buf.indexOf(fromIndex, toIndex, value);
    }

    public synchronized int bytesBefore(byte value) {
        return this.buf.bytesBefore(value);
    }

    public synchronized int bytesBefore(int length, byte value) {
        return this.buf.bytesBefore(length, value);
    }

    public synchronized int bytesBefore(int index, int length, byte value) {
        return this.buf.bytesBefore(index, length, value);
    }

    public synchronized int forEachByte(ByteProcessor processor) {
        return this.buf.forEachByte(processor);
    }

    public synchronized int forEachByte(int index, int length, ByteProcessor processor) {
        return this.buf.forEachByte(index, length, processor);
    }

    public synchronized int forEachByteDesc(ByteProcessor processor) {
        return this.buf.forEachByteDesc(processor);
    }

    public synchronized int forEachByteDesc(int index, int length, ByteProcessor processor) {
        return this.buf.forEachByteDesc(index, length, processor);
    }

    public synchronized ByteBuf copy() {
        return SynchonizedByteBuf.wrap(this.buf.copy());
    }

    public synchronized ByteBuf copy(int index, int length) {
        return SynchonizedByteBuf.wrap(this.buf.copy(index, length));
    }

    public synchronized ByteBuf slice() {
        return SynchonizedByteBuf.wrap(this.buf.slice());
    }

    public synchronized ByteBuf retainedSlice() {
        return SynchonizedByteBuf.wrap(this.buf.retainedSlice());
    }

    public synchronized ByteBuf slice(int index, int length) {
        return SynchonizedByteBuf.wrap(this.buf.slice(index, length));
    }

    public synchronized ByteBuf retainedSlice(int index, int length) {
        return SynchonizedByteBuf.wrap(this.buf.retainedSlice(index, length));
    }

    public synchronized ByteBuf duplicate() {
        return SynchonizedByteBuf.wrap(this.buf.duplicate());
    }

    public synchronized ByteBuf retainedDuplicate() {
        return SynchonizedByteBuf.wrap(this.buf.retainedDuplicate());
    }

    public synchronized int nioBufferCount() {
        return this.buf.nioBufferCount();
    }

    public synchronized ByteBuffer nioBuffer() {
        return this.buf.nioBuffer();
    }

    public synchronized ByteBuffer nioBuffer(int index, int length) {
        return this.buf.nioBuffer(index, length);
    }

    public synchronized ByteBuffer[] nioBuffers() {
        return this.buf.nioBuffers();
    }

    public synchronized ByteBuffer[] nioBuffers(int index, int length) {
        return this.buf.nioBuffers(index, length);
    }

    public synchronized ByteBuffer internalNioBuffer(int index, int length) {
        return this.buf.internalNioBuffer(index, length);
    }

    public synchronized boolean hasArray() {
        return this.buf.hasArray();
    }

    public synchronized byte[] array() {
        return this.buf.array();
    }

    public synchronized int arrayOffset() {
        return this.buf.arrayOffset();
    }

    public synchronized String toString(Charset charset) {
        return this.buf.toString(charset);
    }

    public synchronized String toString(int index, int length, Charset charset) {
        return this.buf.toString(index, length, charset);
    }

    public synchronized int hashCode() {
        return this.buf.hashCode();
    }

    public synchronized boolean equals(Object obj) {
        return this.buf.equals(obj);
    }

    public synchronized int compareTo(ByteBuf buffer) {
        return this.buf.compareTo(buffer);
    }

    public synchronized String toString() {
        return StringUtil.simpleClassName((Object)this) + '(' + this.buf.toString() + ')';
    }

    public synchronized ByteBuf retain(int increment) {
        this.buf.retain(increment);
        return this;
    }

    public synchronized ByteBuf retain() {
        this.buf.retain();
        return this;
    }

    public synchronized ByteBuf touch() {
        this.buf.touch();
        return this;
    }

    public synchronized ByteBuf touch(Object hint) {
        this.buf.touch(hint);
        return this;
    }

    public final synchronized boolean isReadable(int size) {
        return this.buf.isReadable(size);
    }

    public final synchronized boolean isWritable(int size) {
        return this.buf.isWritable(size);
    }

    public final synchronized int refCnt() {
        return this.buf.refCnt();
    }

    public synchronized boolean release() {
        return this.buf.release();
    }

    public synchronized boolean release(int decrement) {
        return this.buf.release(decrement);
    }
}

