/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.spi.buffer;

import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class MutableByteBufInputStream
extends InputStream
implements DataInput {
    private final ByteBuf buffer;
    private final int startIndex;
    private final int endIndex;
    private final StringBuilder lineBuf = new StringBuilder();

    public MutableByteBufInputStream(ByteBuf buffer) {
        this(buffer, buffer.readableBytes());
    }

    public MutableByteBufInputStream(ByteBuf buffer, int length) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length: " + length);
        }
        this.buffer = buffer;
        this.startIndex = buffer.readerIndex();
        this.endIndex = this.startIndex + length;
        buffer.markReaderIndex();
    }

    public ByteBuf buffer() {
        return this.buffer;
    }

    public int readBytes() {
        return this.buffer.readerIndex() - this.startIndex;
    }

    public int readableBytes() {
        return this.endIndex - this.buffer.readerIndex();
    }

    @Override
    public int available() throws IOException {
        return Math.min(this.buffer.readableBytes(), this.readableBytes());
    }

    @Override
    public void mark(int readlimit) {
        this.buffer.markReaderIndex();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer.readerIndex() >= this.endIndex) {
            return -1;
        }
        this.ensureBufferIsReadable(1);
        return this.buffer.readByte() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffer.readerIndex() >= this.endIndex) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        this.ensureBufferIsReadable(1);
        int available = this.available();
        len = Math.min(available, len);
        this.buffer.readBytes(b, off, len);
        return len;
    }

    @Override
    public void reset() throws IOException {
        this.buffer.resetReaderIndex();
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > Integer.MAX_VALUE) {
            return this.skipBytes(Integer.MAX_VALUE);
        }
        return this.skipBytes((int)n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.checkAvailable(1);
        return this.read() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        this.checkAvailable(1);
        return (byte)this.read();
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.checkAvailable(len);
        this.ensureBufferIsReadable(len);
        this.buffer.readBytes(b, off, len);
    }

    public ByteBuf readFully(int len) throws IOException {
        this.checkAvailable(len);
        this.ensureBufferIsReadable(len);
        return this.buffer.readSlice(len);
    }

    public ByteBuf readUntil(byte ... values) throws IOException {
        int len = -1;
        int n = 0;
        block0: do {
            this.checkAvailable(++n);
            this.ensureBufferIsReadable(n);
            byte b = this.buffer.getByte(this.buffer.readerIndex() + n - 1);
            for (byte value : values) {
                int n2 = len = b == value ? n - 1 : -1;
                if (len != -1) continue block0;
            }
        } while (len == -1);
        return this.readFully(len + 1);
    }

    @Override
    public int readInt() throws IOException {
        this.checkAvailable(4);
        this.ensureBufferIsReadable(4);
        return this.buffer.readInt();
    }

    @Override
    public String readLine() throws IOException {
        this.lineBuf.setLength(0);
        block4: while (true) {
            if (this.available() == 0) {
                return this.lineBuf.length() > 0 ? this.lineBuf.toString() : null;
            }
            short c = this.buffer.readUnsignedByte();
            switch (c) {
                case 10: {
                    break block4;
                }
                case 13: {
                    if (this.available() <= 0 || (char)this.buffer.getUnsignedByte(this.buffer.readerIndex()) != '\n') break block4;
                    this.buffer.skipBytes(1);
                    break block4;
                }
                default: {
                    this.lineBuf.append((char)c);
                    continue block4;
                }
            }
            break;
        }
        return this.lineBuf.toString();
    }

    @Override
    public long readLong() throws IOException {
        this.checkAvailable(8);
        this.ensureBufferIsReadable(8);
        return this.buffer.readLong();
    }

    @Override
    public short readShort() throws IOException {
        this.checkAvailable(2);
        this.ensureBufferIsReadable(2);
        return this.buffer.readShort();
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int nBytes = Math.min(this.available(), n);
        this.buffer.skipBytes(nBytes);
        return nBytes;
    }

    private void checkAvailable(int fieldSize) throws IOException {
        if (fieldSize < 0) {
            throw new IndexOutOfBoundsException("fieldSize cannot be a negative number");
        }
        if (this.buffer.readerIndex() + fieldSize > this.endIndex) {
            throw new EOFException("fieldSize is too long! Length is " + fieldSize + ", but maximum is " + (this.buffer.readerIndex() + fieldSize - this.endIndex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureBufferIsReadable(int n) throws IOException {
        while (this.buffer.readableBytes() < n) {
            ByteBuf byteBuf = this.buffer;
            synchronized (byteBuf) {
                if (this.buffer.readableBytes() < n) {
                    try {
                        this.buffer.wait();
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
            }
        }
    }
}

