/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.spi.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.SlicedByteBuf;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ByteBufUtilities {
    private static final Class<?> WRAPPED_BYTEBUF_TYPE;
    private static final Class<?> WRAPPED_COMPOSITEBYTEBUF_TYPE;

    public static boolean containsAt(ByteBuf buffer, ByteBuf part, int position) {
        if (ByteBufUtilities.hasMemoryAddresses(buffer) && ByteBufUtilities.hasMemoryAddresses(part)) {
            long[][] bufferAddresses = ByteBufUtilities.getMemoryAddresses(buffer);
            long[][] partAddresses = ByteBufUtilities.getMemoryAddresses(part);
            for (int i = 0; i < partAddresses.length; ++i) {
                block4: {
                    long partAddress = partAddresses[i][0];
                    long partCapacity = partAddresses[i][1];
                    for (int j = 0; j < bufferAddresses.length; ++j) {
                        long bufferAddress = bufferAddresses[j][0];
                        long bufferCapacity = bufferAddresses[j][1];
                        if (partAddress - bufferAddress != (long)position || bufferAddress + bufferCapacity < partAddress + partCapacity) {
                            if ((long)position < bufferCapacity) continue;
                            position = (int)((long)position - bufferCapacity);
                            continue;
                        }
                        break block4;
                    }
                    return false;
                }
                position = 0;
            }
            return true;
        }
        return false;
    }

    private static boolean hasMemoryAddresses(ByteBuf buffer) {
        if (buffer.hasMemoryAddress()) {
            return true;
        }
        int offset = 0;
        int capacity = buffer.capacity();
        buffer = ByteBufUtilities.unwrap(buffer);
        while (buffer instanceof SlicedByteBuf) {
            SlicedByteBuf sbb = (SlicedByteBuf)buffer;
            offset += ByteBufUtilities.getAdjustment(sbb);
            buffer = sbb.unwrap();
        }
        if (buffer instanceof CompositeByteBuf) {
            CompositeByteBuf cbbBuffer = (CompositeByteBuf)buffer;
            do {
                int bufferIndex;
                ByteBuf subBuffer;
                if (!ByteBufUtilities.hasMemoryAddresses(subBuffer = cbbBuffer.internalComponent(bufferIndex = cbbBuffer.toComponentIndex(offset)))) {
                    return false;
                }
                if (subBuffer.capacity() < capacity) {
                    offset += subBuffer.capacity();
                    capacity -= subBuffer.capacity();
                    continue;
                }
                offset += capacity;
                capacity -= capacity;
            } while (capacity > 0);
            return true;
        }
        return false;
    }

    private static long[][] getMemoryAddresses(ByteBuf buffer) {
        if (buffer.hasMemoryAddress()) {
            return new long[][]{{buffer.memoryAddress(), buffer.capacity()}};
        }
        buffer = ByteBufUtilities.unwrap(buffer);
        int offset = 0;
        int capacity = buffer.capacity();
        while (buffer instanceof SlicedByteBuf) {
            SlicedByteBuf sbb = (SlicedByteBuf)buffer;
            offset += ByteBufUtilities.getAdjustment(sbb);
            buffer = sbb.unwrap();
        }
        if (buffer instanceof CompositeByteBuf) {
            CompositeByteBuf cbbBuffer = (CompositeByteBuf)buffer;
            ArrayList<long[]> memoryAddresses = new ArrayList<long[]>();
            do {
                int bufferIndex = cbbBuffer.toComponentIndex(offset);
                int bufferOffset = cbbBuffer.toByteIndex(bufferIndex);
                ByteBuf subBuffer = cbbBuffer.internalComponent(bufferIndex);
                long[][] subMemoryAddresses = ByteBufUtilities.getMemoryAddresses(subBuffer);
                if (subMemoryAddresses == null) {
                    return null;
                }
                for (int i = 0; i < subMemoryAddresses.length && capacity > 0; ++i) {
                    long addr = subMemoryAddresses[i][0];
                    long cap = subMemoryAddresses[i][1];
                    if (i == 0) {
                        addr += (long)(offset - bufferOffset);
                        cap -= (long)(offset - bufferOffset);
                    }
                    if (cap > (long)capacity) {
                        cap = capacity;
                    }
                    memoryAddresses.add(new long[]{addr, cap});
                    capacity = (int)((long)capacity - cap);
                    offset = (int)((long)offset + cap);
                }
            } while (capacity > 0);
            return (long[][])memoryAddresses.stream().toArray(x$0 -> new long[x$0][]);
        }
        return null;
    }

    private static int getAdjustment(SlicedByteBuf slicedByteBuf) {
        try {
            Method adjustment = SlicedByteBuf.class.getDeclaredMethod("adjustment", new Class[0]);
            adjustment.setAccessible(true);
            return (Integer)adjustment.invoke((Object)slicedByteBuf, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return 0;
        }
    }

    public static ByteBuf unwrap(ByteBuf buffer) {
        while (WRAPPED_BYTEBUF_TYPE.isInstance(buffer) || WRAPPED_COMPOSITEBYTEBUF_TYPE.isInstance(buffer)) {
            buffer = buffer.unwrap();
        }
        return buffer;
    }

    static {
        Class<?> byteBufType = null;
        Class<?> compositeByteBufType = null;
        try {
            byteBufType = Class.forName("io.netty.buffer.WrappedByteBuf");
            compositeByteBufType = Class.forName("io.netty.buffer.WrappedCompositeByteBuf");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        WRAPPED_BYTEBUF_TYPE = byteBufType;
        WRAPPED_COMPOSITEBYTEBUF_TYPE = compositeByteBufType;
    }
}

