/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.spi;

import eu.clarussecure.proxy.spi.buffer.CustomByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CString
implements CharSequence,
Cloneable,
Comparable<CharSequence>,
ReferenceCounted {
    private static final Logger LOGGER = LoggerFactory.getLogger(CString.class);
    private ByteBuf buffer;
    private int strLen;
    private CharSequence str;
    private int hash;

    public static CString valueOf(ByteBuf buffer) {
        if (buffer == null) {
            return null;
        }
        return new CString(buffer);
    }

    public static CString valueOf(ByteBuf buffer, int strLen) {
        if (buffer == null) {
            return null;
        }
        return new CString(buffer, strLen);
    }

    public static CString valueOf(CharSequence cs) {
        if (cs == null) {
            return null;
        }
        return new CString(cs);
    }

    private CString(ByteBuf buffer) {
        this(buffer, null, -1);
    }

    private CString(ByteBuf buffer, int strLen) {
        this(buffer, null, strLen);
    }

    private CString(CharSequence cs) {
        this(null, cs, -1);
    }

    private CString(ByteBuf buffer, CharSequence cs, int strLen) {
        this.buffer = buffer;
        this.strLen = strLen;
        if (buffer != null && this.strLen == -1) {
            this.strLen = buffer.bytesBefore((byte)0);
            if (this.strLen == -1) {
                this.strLen = buffer.writerIndex();
            }
        }
        this.str = cs;
    }

    private CString(ByteBuf buffer, int strLen, CharSequence cs, int hash) {
        this.buffer = buffer;
        this.strLen = strLen;
        this.str = cs;
        this.hash = hash;
    }

    public Object clone() {
        ByteBuf newBuffer = this.buffer == null ? null : this.buffer.copy();
        return new CString(newBuffer, this.strLen, this.str, this.hash);
    }

    public int refCnt() {
        if (this.buffer != null) {
            return this.buffer.refCnt();
        }
        return 0;
    }

    public ReferenceCounted retain() {
        if (this.buffer != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Retaining CString's buffer by 1:  {} ({}), refcount={}", new Object[]{this.toString(), System.identityHashCode(this), this.buffer.refCnt()});
            }
            this.buffer.retain();
        }
        return this;
    }

    public ReferenceCounted retain(int increment) {
        if (this.buffer != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Retaining CString's buffer by {}:  {} ({}), refcount={}", new Object[]{increment, this.toString(), System.identityHashCode(this), this.buffer.refCnt()});
            }
            this.buffer.retain(increment);
        }
        return this;
    }

    public ReferenceCounted touch() {
        if (this.buffer != null) {
            this.buffer.touch();
        }
        return this;
    }

    public ReferenceCounted touch(Object hint) {
        if (this.buffer != null) {
            this.buffer.touch(hint);
        }
        return this;
    }

    public boolean release() {
        if (this.buffer != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Releasing CString's buffer by 1:  {} ({}), refcount={}", new Object[]{this.toString(), System.identityHashCode(this), this.buffer.refCnt()});
            }
            if (this.buffer.release()) {
                this.buffer = null;
                this.strLen = 0;
                this.hash = 0;
            }
        }
        return this.buffer == null;
    }

    public boolean release(int decrement) {
        if (this.buffer != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Releasing CString's buffer by {}: {} ({}), refcount={}", new Object[]{decrement, this.toString(), System.identityHashCode(this), this.buffer.refCnt()});
            }
            if (this.buffer.release(decrement)) {
                this.buffer = null;
                this.strLen = 0;
                this.hash = 0;
            }
        }
        return this.buffer == null;
    }

    public boolean isBuffered() {
        return this.buffer != null;
    }

    public ByteBuf getByteBuf(int maxCapacity) {
        ByteBuf bytebuf = this.getByteBuf();
        if (bytebuf != null && bytebuf.capacity() > maxCapacity) {
            bytebuf = bytebuf.slice(0, maxCapacity);
        }
        return bytebuf;
    }

    public ByteBuf getByteBuf() {
        if (this.buffer == null && this.str != null) {
            this.buffer = ByteBufUtil.encodeString((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (CharBuffer)CharBuffer.wrap(this.str), (Charset)StandardCharsets.ISO_8859_1, (int)1);
            this.buffer.writeByte(0);
            this.strLen = this.buffer.writerIndex() - 1;
        }
        return this.buffer;
    }

    @Override
    public int length() {
        return this.str != null ? this.str.length() : this.strLen;
    }

    public int clen() {
        return this.length() + 1;
    }

    @Override
    public boolean isEmpty() {
        return this.str != null ? this.str.length() == 0 : this.strLen == 0;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.str != null ? this.str.charAt(index) : (char)(this.buffer.getByte(index) & 0xFF);
    }

    public CString substring(int beginIndex) {
        return this.subSequence(beginIndex, this.length());
    }

    public CString substring(int beginIndex, int endIndex) {
        return this.subSequence(beginIndex, endIndex);
    }

    @Override
    public CString subSequence(int start, int end) {
        CharSequence subCs = null;
        if (this.str != null) {
            subCs = this.str.subSequence(start, end > this.str.length() ? this.str.length() : end);
        }
        ByteBuf subBuffer = null;
        if (this.buffer != null) {
            subBuffer = this.buffer.slice(start, end - start);
            while (subBuffer.getByte(end - start - 1) == 0) {
                --end;
            }
        }
        return new CString(subBuffer, subCs, end - start);
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(int ch, int fromIndex) {
        int max = this.length();
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= max) {
            return -1;
        }
        for (int i = fromIndex; i < max; ++i) {
            if (this.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(CharSequence target) {
        return this.indexOf(target, 0);
    }

    public int indexOf(CharSequence target, int fromIndex) {
        return CString.indexOf(this, 0, this.length(), target, 0, target.length(), fromIndex);
    }

    private static int indexOf(CString source, int sourceOffset, int sourceCount, CharSequence target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target.charAt(targetOffset);
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source.charAt(i) != first) {
                while (++i <= max && source.charAt(i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source.charAt(j) == target.charAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public int lastIndexOf(int ch) {
        return this.lastIndexOf(ch, this.length() - 1);
    }

    public int lastIndexOf(int ch, int fromIndex) {
        for (int i = Math.min(fromIndex, this.length() - 1); i >= 0; --i) {
            if (this.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(CharSequence target) {
        return this.lastIndexOf(target, 0);
    }

    public int lastIndexOf(CharSequence target, int fromIndex) {
        return CString.lastIndexOf(this, 0, this.length(), target, 0, target.length(), fromIndex);
    }

    static int lastIndexOf(CString source, int sourceOffset, int sourceCount, CharSequence target, int targetOffset, int targetCount, int fromIndex) {
        int start;
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        char strLastChar = target.charAt(strLastIndex);
        int min = sourceOffset + targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && source.charAt(i) != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (source.charAt(j--) == target.charAt(k--)) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start - sourceOffset + 1;
    }

    public boolean startsWith(CharSequence prefix, int toffset) {
        int to = toffset;
        int po = 0;
        int pc = prefix.length();
        if (toffset < 0 || toffset > this.length() - prefix.length()) {
            return false;
        }
        while (--pc >= 0) {
            if (this.charAt(to++) == prefix.charAt(po++)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(CharSequence prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean endsWith(CharSequence suffix) {
        return this.startsWith(suffix, this.length() - suffix.length());
    }

    public CString replace(char oldChar, char newChar) {
        CString cs = this;
        if (oldChar != newChar) {
            int from = 0;
            for (int i = 0; i < this.length(); ++i) {
                if (this.charAt(i) != oldChar) continue;
                if (cs == this) {
                    cs = this.substring(from, i);
                } else {
                    cs.append(this.substring(from, i));
                }
                cs.append(newChar);
                from = i + 1;
            }
            if (from < this.length() && cs != this) {
                cs.append(this.substring(from, this.length()));
            }
        }
        return cs;
    }

    public CString replace(CharSequence target, CharSequence replacement) {
        CString cs = this;
        if (target != replacement) {
            int from = 0;
            for (int i = 0; i < this.length() - target.length(); ++i) {
                if (!this.substring(i, target.length()).equals(target)) continue;
                if (cs == this) {
                    cs = this.substring(from, i);
                } else {
                    cs.append(this.substring(from, i));
                }
                cs.append(replacement);
                from = i + replacement.length();
                i += replacement.length() - 1;
            }
            if (from < this.length() && cs != this) {
                cs.append(this.substring(from, this.length()));
            }
        }
        return cs;
    }

    public CString append(char c) {
        return this.append(new char[]{c});
    }

    public CString append(char[] array) {
        return this.append(CharBuffer.wrap(array));
    }

    public CString append(CharSequence other) {
        return this.append(other, other.length());
    }

    public CString append(CharSequence other, int length) {
        if (length <= 0) {
            return this;
        }
        if (this.buffer != null) {
            this.ensureBufferCapacity(other, length);
            if (this.buffer.writerIndex() > 0 && this.buffer.getByte(this.buffer.writerIndex() - 1) == 0) {
                this.buffer.writerIndex(this.buffer.writerIndex() - 1);
            }
            if (other instanceof CString && ((CString)other).buffer != null) {
                this.copy(((CString)other).buffer, length);
            } else {
                this.copy(other, length);
            }
            this.strLen += length;
        }
        if (this.str != null) {
            CharSequence src = other;
            if (other instanceof CString && ((CString)other).str != null) {
                src = ((CString)other).str;
            }
            if (!(this.str instanceof Appendable)) {
                this.str = new StringBuilder(this.str);
            }
            try {
                ((Appendable)((Object)this.str)).append(src.subSequence(0, length));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        this.hash = 0;
        return this;
    }

    private void ensureBufferCapacity(CharSequence other, int length) {
        if (this.buffer instanceof CompositeByteBuf && this.buffer.writerIndex() > 0 && this.buffer.getByte(this.buffer.writerIndex() - 1) == 0) {
            int index = ((CompositeByteBuf)this.buffer).toComponentIndex(this.strLen);
            ByteBuf last = ((CompositeByteBuf)this.buffer).internalComponent(index);
            if (last.capacity() == 1) {
                ((CompositeByteBuf)this.buffer).removeComponent(index);
                this.buffer.writerIndex(this.buffer.writerIndex() - 1);
            } else {
                this.buffer.capacity(this.strLen);
            }
        }
        if (!(this.buffer instanceof CompositeByteBuf && ((CompositeByteBuf)this.buffer).numComponents() != ((CompositeByteBuf)this.buffer).maxNumComponents() && other instanceof CString && ((CString)other).buffer != null || this.buffer.capacity() - this.strLen >= length + 1)) {
            if (this.buffer.maxCapacity() > this.strLen + length + 1) {
                this.buffer.capacity(this.strLen + length + 1);
            } else {
                ByteBuf newBuffer = this.buffer.alloc().buffer(this.strLen + length + 1);
                newBuffer.writeBytes(this.buffer);
                this.buffer.release();
                this.buffer = newBuffer;
            }
        }
    }

    private void copy(ByteBuf src, int length) {
        if (this.buffer instanceof CompositeByteBuf && ((CompositeByteBuf)this.buffer).numComponents() < ((CompositeByteBuf)this.buffer).maxNumComponents() - 1) {
            ((CompositeByteBuf)this.buffer).addComponent(true, src.slice(0, length));
            ((CompositeByteBuf)this.buffer).capacity(this.strLen + length + 1);
            this.buffer.writeByte(0);
        } else {
            long srcAddr;
            long dstAddr;
            boolean copy = true;
            if (this.buffer.hasMemoryAddress() && src.hasMemoryAddress() && (dstAddr = this.buffer.memoryAddress() + (long)this.buffer.writerIndex()) == (srcAddr = src.memoryAddress()) && dstAddr + (long)this.buffer.writableBytes() >= srcAddr + (long)length + 1L) {
                copy = false;
            }
            if (copy) {
                this.buffer.writeBytes(src, length);
                this.buffer.writeByte(0);
            } else {
                this.buffer.writerIndex(this.buffer.writerIndex() + length + 1);
            }
        }
    }

    private void copy(CharSequence other, int length) {
        CustomByteBufAllocator allocator = new CustomByteBufAllocator(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public ByteBuf buffer(int length) {
                ByteBuf byteBuf = null;
                if (CString.this.buffer instanceof CompositeByteBuf) {
                    List byteBufs = ((CompositeByteBuf)CString.this.buffer).decompose(CString.this.buffer.writerIndex(), length);
                    if (byteBufs.size() != 1) throw new UnsupportedOperationException();
                    byteBuf = (ByteBuf)byteBufs.get(0);
                } else {
                    byteBuf = CString.this.buffer.slice(CString.this.buffer.writerIndex(), length);
                }
                byteBuf.writerIndex(0);
                return byteBuf;
            }
        };
        ByteBuf src = ByteBufUtil.encodeString((ByteBufAllocator)allocator, (CharBuffer)CharBuffer.wrap(other.subSequence(0, length)), (Charset)StandardCharsets.ISO_8859_1, (int)1);
        src.writeByte(0);
        this.buffer.writerIndex(this.buffer.writerIndex() + src.writerIndex());
    }

    public CString reset() {
        if (this.buffer != null) {
            this.buffer.readerIndex(0);
            this.buffer.writerIndex(0);
            this.strLen = 0;
        }
        this.str = null;
        this.hash = 0;
        return this;
    }

    @Override
    public String toString() {
        if (this.str == null) {
            if (this.buffer == null) {
                return null;
            }
            this.str = this.buffer.toString(0, this.strLen, StandardCharsets.ISO_8859_1);
        }
        return this.str.toString();
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            if (this.str != null) {
                h = this.str.hashCode();
            } else if (this.buffer != null) {
                for (int i = 0; i < this.strLen; ++i) {
                    h = 31 * h + (this.buffer.getByte(i) & 0xFF);
                }
            }
            this.hash = h;
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CharSequence)) {
            return false;
        }
        CharSequence other = (CharSequence)obj;
        if (this.length() != other.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (this.charAt(i) == other.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(CharSequence cs) {
        return this == cs ? true : cs != null && cs.length() == this.length() && this.regionMatches(true, 0, cs, 0, this.length());
    }

    public boolean regionMatches(boolean ignoreCase, int toffset, CharSequence other, int ooffset, int len) {
        int to = toffset;
        int po = ooffset;
        if (ooffset < 0 || toffset < 0 || (long)toffset > (long)this.length() - (long)len || (long)ooffset > (long)other.length() - (long)len) {
            return false;
        }
        while (len-- > 0) {
            char u2;
            char u1;
            char c2;
            char c1;
            if ((c1 = this.charAt(to++)) == (c2 = other.charAt(po++)) || ignoreCase && ((u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(CharSequence other) {
        int len1 = this.length();
        int len2 = other.length();
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            char c2;
            char c1 = this.charAt(k);
            if (c1 == (c2 = other.charAt(k))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }
}

