/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.dataoperations.anonymization;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class SymmetricCrypto {
    public static final String KEY = "." + File.separator + "keys" + File.separator + "AES.key";

    public static byte[] encrypt(String text, String key) throws FileNotFoundException, IOException, ClassNotFoundException {
        return SymmetricCrypto.encrypt(text.getBytes(), key);
    }

    public static byte[] encrypt(byte[] text, String key) throws FileNotFoundException, IOException, ClassNotFoundException {
        ObjectInputStream keyStream = new ObjectInputStream(new FileInputStream(key));
        SecretKey publicKey = (SecretKey)keyStream.readObject();
        keyStream.close();
        return SymmetricCrypto.encrypt(text, publicKey);
    }

    public static byte[] encrypt(byte[] text, SecretKey key) {
        byte[] cipherText = null;
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, key);
            cipherText = cipher.doFinal(text);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cipherText;
    }

    public static byte[] decrypt(String text, String key) throws FileNotFoundException, IOException, ClassNotFoundException {
        return SymmetricCrypto.decrypt(text.getBytes(), key);
    }

    public static byte[] decrypt(byte[] text, String key) throws FileNotFoundException, IOException, ClassNotFoundException {
        ObjectInputStream keyStream = new ObjectInputStream(new FileInputStream(key));
        SecretKey publicKey = (SecretKey)keyStream.readObject();
        keyStream.close();
        return SymmetricCrypto.decrypt(text, publicKey);
    }

    public static byte[] decrypt(byte[] text, SecretKey key) {
        byte[] dectyptedText = null;
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, key);
            dectyptedText = cipher.doFinal(text);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dectyptedText;
    }

    public static void generateKey() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(128);
            SecretKey key = keyGen.generateKey();
            File keyFile = new File(KEY);
            if (keyFile.getParentFile() != null) {
                keyFile.getParentFile().mkdirs();
            }
            keyFile.createNewFile();
            ObjectOutputStream keyOS = new ObjectOutputStream(new FileOutputStream(keyFile));
            keyOS.writeObject(key);
            keyOS.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

