/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.dataoperations.anonymization;

import eu.clarussecure.dataoperations.anonymization.RecordQ;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.regex.Pattern;

public class Record {
    static String attributeSeparator;
    static String recordSeparator;
    static boolean header;
    static int numAttr;
    static int numQuasi;
    static HashMap<String, String> attrTypes;
    static int k;
    static double t;
    static int clouds;
    static String idKey;
    static String coarsening_type;
    static double radius;
    static int refNumAttr;
    static ArrayList<String> refListNames;
    static ArrayList<Pattern> refListNamePatterns;
    static ArrayList<String> refListAttrTypes;
    static ArrayList<String> refListDataTypes;
    static ArrayList<String> listNames;
    static ArrayList<Pattern> listNamePatterns;
    static ArrayList<String> listAttrTypes;
    static ArrayList<String> listDataTypes;
    String[] attrValues;
    int id;

    public Record(int id) {
        this.attrValues = new String[numAttr];
        this.id = id;
    }

    public Record(int id, int numAttr) {
        this.attrValues = new String[numAttr];
        this.id = id;
    }

    public RecordQ toRecordQ() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format1 = new SimpleDateFormat("yyyy/MM/dd");
        RecordQ recordQ = new RecordQ(this.id);
        int pos = 0;
        for (int i = 0; i < listAttrTypes.size(); ++i) {
            String attrType = listAttrTypes.get(i);
            if (!attrType.equalsIgnoreCase("quasi_identifier")) continue;
            String dataType = listDataTypes.get(i);
            if (dataType.equalsIgnoreCase("date")) {
                String value = this.attrValues[i];
                try {
                    calendar.setTime(format1.parse(value));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                recordQ.attrValues[pos] = String.valueOf(calendar.getTimeInMillis());
            } else {
                recordQ.attrValues[pos] = this.attrValues[i];
            }
            ++pos;
        }
        return recordQ;
    }

    public RecordQ toRecordQConfidential() {
        String attrType;
        int i;
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format1 = new SimpleDateFormat("yyyy/MM/dd");
        RecordQ recordQ = new RecordQ(this.id);
        int pos = 0;
        for (i = 0; i < listAttrTypes.size(); ++i) {
            attrType = listAttrTypes.get(i);
            if (!attrType.equalsIgnoreCase("quasi_identifier")) continue;
            String dataType = listDataTypes.get(i);
            if (dataType.equalsIgnoreCase("date")) {
                String value = this.attrValues[i];
                try {
                    calendar.setTime(format1.parse(value));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                recordQ.attrValues[pos] = String.valueOf(calendar.getTimeInMillis());
            } else {
                recordQ.attrValues[pos] = this.attrValues[i];
            }
            ++pos;
        }
        for (i = 0; i < listAttrTypes.size(); ++i) {
            attrType = listAttrTypes.get(i);
            if (!attrType.equalsIgnoreCase("confidential")) continue;
            recordQ.attrValues[pos] = this.attrValues[i];
            break;
        }
        return recordQ;
    }

    public Record clone() {
        Record record = new Record(this.id);
        for (int i = 0; i < this.attrValues.length; ++i) {
            record.attrValues[i] = this.attrValues[i];
        }
        return record;
    }

    public String toString() {
        String str = "";
        for (String s : this.attrValues) {
            str = str + s + attributeSeparator;
        }
        if (str.equals("")) {
            return "";
        }
        return str.substring(0, str.length() - 1) + recordSeparator;
    }

    public String[] toVectorString() {
        String[] str = new String[numAttr];
        for (int i = 0; i < numAttr; ++i) {
            str[i] = this.attrValues[i];
        }
        return str;
    }

    public StringBuilder toStringBuilder() {
        StringBuilder str = new StringBuilder("");
        for (String s : this.attrValues) {
            str.append(s).append(attributeSeparator);
        }
        if (str.equals("")) {
            return new StringBuilder("");
        }
        return new StringBuilder(str.substring(0, str.length() - 1)).append(recordSeparator);
    }
}

